/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.expression;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.provider.expression.ExpressionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Expression.class);
    private final Map<String, Object> expressionCache;
    private final ExpressionContext context;

    public Expression(ExpressionContext context) {
        this.context = context;
        this.expressionCache = new ConcurrentHashMap<String, Object>();
    }

    public Object eval(String expression) {
        return this.eval(expression, null);
    }

    public Object eval(String expression, Map<String, Object> vars) {
        try {
            Object obj = this.compile(expression, this.context);
            return MVEL.executeExpression((Object)obj, vars);
        }
        catch (Throwable e) {
            log.error("eval expression {} error", (Object)expression, (Object)e);
            return null;
        }
    }

    public Object compile(String expression, ExpressionContext pctx) {
        return this.expressionCache.computeIfAbsent(expression, s -> MVEL.compileExpression((String)expression, (ParserContext)pctx.getContext()));
    }

    public Set<String> analysisInputs(String expression) {
        ParserContext pCtx = ParserContext.create();
        MVEL.analysisCompile((String)expression, (ParserContext)pCtx);
        Map inputsMap = pCtx.getInputs();
        return inputsMap.keySet();
    }
}

