/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.discord;

import com.google.gson.JsonObject;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordHookCallback
implements AlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscordHookCallback.class);
    private static final int HTTP_CONNECT_TIMEOUT = 1000;
    private static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 1000;
    private static final int HTTP_SOCKET_TIMEOUT = 10000;
    private final AlarmRulesWatcher alarmRulesWatcher;
    private final RequestConfig requestConfig;

    public DiscordHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    public void doAlarm(List<AlarmMessage> alarmMessages) {
        DiscordSettings discordSettings = this.alarmRulesWatcher.getDiscordSettings();
        if (discordSettings == null || discordSettings.getWebhooks().isEmpty()) {
            return;
        }
        discordSettings.getWebhooks().forEach(webHookUrl -> alarmMessages.forEach(alarmMessage -> {
            String content = String.format(discordSettings.getTextTemplate(), alarmMessage.getAlarmMessage());
            this.sendAlarmMessage((DiscordSettings.WebHookUrl)webHookUrl, content);
        }));
    }

    private void sendAlarmMessage(DiscordSettings.WebHookUrl webHookUrl, String content) {
        JsonObject body = new JsonObject();
        body.addProperty("username", webHookUrl.getUsername());
        body.addProperty("content", content);
        this.sendPostRequest(webHookUrl.getUrl(), body.toString());
    }

    private void sendPostRequest(String url, String requestBody) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(url);
            post.setConfig(this.requestConfig);
            post.setHeader("Accept", HttpHeaderValues.APPLICATION_JSON.toString());
            post.setHeader("Content-Type", HttpHeaderValues.APPLICATION_JSON.toString());
            StringEntity entity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);){
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 204) {
                    log.error("send to {} failure. Response code: {}, Response content: {}", new Object[]{url, statusLine.getStatusCode(), EntityUtils.toString((HttpEntity)httpResponse.getEntity())});
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

