/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmMessageFormatter;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.MetricsValueType;
import org.apache.skywalking.oap.server.core.alarm.provider.OP;
import org.apache.skywalking.oap.server.core.alarm.provider.Threshold;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunningRule.class);
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    private final String ruleName;
    private final int period;
    private final String metricsName;
    private final Threshold threshold;
    private final OP op;
    private final int countThreshold;
    private final int silencePeriod;
    private final Map<MetaInAlarm, Window> windows;
    private volatile MetricsValueType valueType;
    private final List<String> includeNames;
    private final List<String> excludeNames;
    private final Pattern includeNamesRegex;
    private final Pattern excludeNamesRegex;
    private final List<String> includeLabels;
    private final List<String> excludeLabels;
    private final Pattern includeLabelsRegex;
    private final Pattern excludeLabelsRegex;
    private final AlarmMessageFormatter formatter;
    private final boolean onlyAsCondition;
    private final List<Tag> tags;

    public RunningRule(AlarmRule alarmRule) {
        this.metricsName = alarmRule.getMetricsName();
        this.ruleName = alarmRule.getAlarmRuleName();
        this.windows = new ConcurrentHashMap<MetaInAlarm, Window>();
        this.period = alarmRule.getPeriod();
        this.threshold = new Threshold(alarmRule.getAlarmRuleName(), alarmRule.getThreshold());
        this.op = OP.get(alarmRule.getOp());
        this.countThreshold = alarmRule.getCount();
        this.silencePeriod = alarmRule.getSilencePeriod();
        this.includeNames = alarmRule.getIncludeNames();
        this.excludeNames = alarmRule.getExcludeNames();
        this.includeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getIncludeNamesRegex()) ? Pattern.compile(alarmRule.getIncludeNamesRegex()) : null;
        this.excludeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getExcludeNamesRegex()) ? Pattern.compile(alarmRule.getExcludeNamesRegex()) : null;
        this.includeLabels = alarmRule.getIncludeLabels();
        this.excludeLabels = alarmRule.getExcludeLabels();
        this.includeLabelsRegex = StringUtil.isNotEmpty((String)alarmRule.getIncludeLabelsRegex()) ? Pattern.compile(alarmRule.getIncludeLabelsRegex()) : null;
        this.excludeLabelsRegex = StringUtil.isNotEmpty((String)alarmRule.getExcludeLabelsRegex()) ? Pattern.compile(alarmRule.getExcludeLabelsRegex()) : null;
        this.formatter = new AlarmMessageFormatter(alarmRule.getMessage());
        this.onlyAsCondition = alarmRule.isOnlyAsCondition();
        this.tags = alarmRule.getTags().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public void in(MetaInAlarm meta, Metrics metrics) {
        if (!meta.getMetricsName().equals(this.metricsName)) {
            if (log.isTraceEnabled()) {
                log.trace("Metric names are inconsistent, {}-{}", (Object)meta.getMetricsName(), (Object)this.metricsName);
            }
            return;
        }
        String metaName = meta.getName();
        if (!this.validate(metaName, this.includeNames, this.excludeNames, this.includeNamesRegex, this.excludeNamesRegex)) {
            return;
        }
        if (this.valueType == null) {
            if (metrics instanceof LongValueHolder) {
                this.valueType = MetricsValueType.LONG;
                this.threshold.setType(MetricsValueType.LONG);
            } else if (metrics instanceof IntValueHolder) {
                this.valueType = MetricsValueType.INT;
                this.threshold.setType(MetricsValueType.INT);
            } else if (metrics instanceof DoubleValueHolder) {
                this.valueType = MetricsValueType.DOUBLE;
                this.threshold.setType(MetricsValueType.DOUBLE);
            } else if (metrics instanceof MultiIntValuesHolder) {
                this.valueType = MetricsValueType.MULTI_INTS;
                this.threshold.setType(MetricsValueType.MULTI_INTS);
            } else if (metrics instanceof LabeledValueHolder) {
                if (((LabeledValueHolder)metrics).getValue().keys().stream().noneMatch(label -> this.validate((String)label, this.includeLabels, this.excludeLabels, this.includeLabelsRegex, this.excludeLabelsRegex))) {
                    return;
                }
                this.valueType = MetricsValueType.LABELED_LONG;
                this.threshold.setType(MetricsValueType.LONG);
            } else {
                log.warn("Unsupported value type {}", (Object)this.valueType);
                return;
            }
        }
        if (this.valueType != null) {
            Window window = this.windows.computeIfAbsent(meta, ignored -> new Window(this.period));
            window.add(metrics);
        }
    }

    private boolean validate(String target, List<String> includeList, List<String> excludeList, Pattern includeRegex, Pattern excludeRegex) {
        if (CollectionUtils.isNotEmpty(includeList) && !includeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} isn't in the including list {}", (Object)target, includeList);
            }
            return false;
        }
        if (CollectionUtils.isNotEmpty(excludeList) && excludeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} is in the excluding list {}", (Object)target, excludeList);
            }
            return false;
        }
        if (includeRegex != null && !includeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} doesn't match the include regex {}", (Object)target, (Object)includeRegex);
            }
            return false;
        }
        if (excludeRegex != null && excludeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} matches the exclude regex {}", (Object)target, (Object)excludeRegex);
            }
            return false;
        }
        return true;
    }

    public void moveTo(LocalDateTime targetTime) {
        this.windows.values().forEach(window -> window.moveTo(targetTime));
    }

    public List<AlarmMessage> check() {
        ArrayList<AlarmMessage> alarmMessageList = new ArrayList<AlarmMessage>(30);
        this.windows.forEach((meta, window) -> {
            Optional<AlarmMessage> alarmMessageOptional = window.checkAlarm();
            if (alarmMessageOptional.isPresent()) {
                AlarmMessage alarmMessage = alarmMessageOptional.get();
                alarmMessage.setScopeId(meta.getScopeId());
                alarmMessage.setScope(meta.getScope());
                alarmMessage.setName(meta.getName());
                alarmMessage.setId0(meta.getId0());
                alarmMessage.setId1(meta.getId1());
                alarmMessage.setRuleName(this.ruleName);
                alarmMessage.setAlarmMessage(this.formatter.format((MetaInAlarm)meta));
                alarmMessage.setOnlyAsCondition(this.onlyAsCondition);
                alarmMessage.setStartTime(System.currentTimeMillis());
                alarmMessage.setPeriod(this.period);
                alarmMessage.setTags(this.tags);
                alarmMessageList.add(alarmMessage);
            }
        });
        return alarmMessageList;
    }

    private LinkedList<TraceLogMetric> transformValues(LinkedList<Metrics> values) {
        LinkedList<TraceLogMetric> r = new LinkedList<TraceLogMetric>();
        values.forEach(m -> {
            if (m == null) {
                r.add(null);
                return;
            }
            switch (this.valueType) {
                case LONG: {
                    r.add(new TraceLogMetric(m.getTimeBucket(), new Number[]{((LongValueHolder)m).getValue()}));
                    break;
                }
                case INT: {
                    r.add(new TraceLogMetric(m.getTimeBucket(), new Number[]{((IntValueHolder)m).getValue()}));
                    break;
                }
                case DOUBLE: {
                    r.add(new TraceLogMetric(m.getTimeBucket(), new Number[]{((DoubleValueHolder)m).getValue()}));
                    break;
                }
                case MULTI_INTS: {
                    int[] iArr = ((MultiIntValuesHolder)m).getValues();
                    r.add(new TraceLogMetric(m.getTimeBucket(), (Number[])Arrays.stream(iArr).boxed().toArray(Number[]::new)));
                    break;
                }
                case LABELED_LONG: {
                    DataTable dt = ((LabeledValueHolder)m).getValue();
                    TraceLogMetric l = new TraceLogMetric(m.getTimeBucket(), dt.sortedValues(Comparator.naturalOrder()).toArray(new Number[0]));
                    TraceLogMetric.access$1302(l, dt.sortedKeys(Comparator.naturalOrder()).toArray(new String[0]));
                    r.add(l);
                }
            }
        });
        return r;
    }

    private static class TraceLogMetric {
        private final long timeBucket;
        private final Number[] value;
        private String[] labels;

        @Generated
        public TraceLogMetric(long timeBucket, Number[] value) {
            this.timeBucket = timeBucket;
            this.value = value;
        }

        @Generated
        public String toString() {
            return "RunningRule.TraceLogMetric(timeBucket=" + this.timeBucket + ", value=" + Arrays.deepToString(this.value) + ", labels=" + Arrays.deepToString(this.labels) + ")";
        }

        static /* synthetic */ String[] access$1302(TraceLogMetric x0, String[] x1) {
            x0.labels = x1;
            return x1;
        }
    }

    public class Window {
        private LocalDateTime endTime;
        private int period;
        private int silenceCountdown;
        private LinkedList<Metrics> values;
        private ReentrantLock lock = new ReentrantLock();

        public Window(int period) {
            this.period = period;
            this.silenceCountdown = -1;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveTo(LocalDateTime current) {
            this.lock.lock();
            try {
                if (this.endTime == null) {
                    this.init();
                } else {
                    int minutes = Minutes.minutesBetween((ReadablePartial)this.endTime, (ReadablePartial)current).getMinutes();
                    if (minutes <= 0) {
                        return;
                    }
                    if (minutes > this.values.size()) {
                        this.init();
                    } else {
                        for (int i = 0; i < minutes; ++i) {
                            this.values.removeFirst();
                            this.values.addLast(null);
                        }
                    }
                }
                this.endTime = current;
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Move window {}", (Object)RunningRule.this.transformValues(this.values));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Metrics metrics) {
            long bucket = metrics.getTimeBucket();
            LocalDateTime timeBucket = TIME_BUCKET_FORMATTER.parseLocalDateTime(bucket + "");
            this.lock.lock();
            try {
                int minutes;
                if (this.endTime == null) {
                    this.init();
                    this.endTime = timeBucket;
                }
                if ((minutes = Minutes.minutesBetween((ReadablePartial)timeBucket, (ReadablePartial)this.endTime).getMinutes()) < 0) {
                    this.moveTo(timeBucket);
                    minutes = 0;
                }
                if (minutes >= this.values.size()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Timebucket is {}, endTime is {} and value size is {}", new Object[]{timeBucket, this.endTime, this.values.size()});
                    }
                    return;
                }
                this.values.set(this.values.size() - minutes - 1, metrics);
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Add metric {} to window {}", (Object)metrics, (Object)RunningRule.this.transformValues(this.values));
            }
        }

        public Optional<AlarmMessage> checkAlarm() {
            if (this.isMatch()) {
                if (this.silenceCountdown < 1) {
                    this.silenceCountdown = RunningRule.this.silencePeriod;
                    return Optional.of(new AlarmMessage());
                }
                --this.silenceCountdown;
            } else {
                --this.silenceCountdown;
            }
            return Optional.empty();
        }

        private boolean isMatch() {
            int matchCount = 0;
            block7: for (Metrics metrics : this.values) {
                if (metrics == null) continue;
                block0 : switch (RunningRule.this.valueType) {
                    case LONG: {
                        long lvalue = ((LongValueHolder)metrics).getValue();
                        long lexpected = RunningRule.this.threshold.getLongThreshold();
                        if (!RunningRule.this.op.test(lexpected, lvalue)) break;
                        ++matchCount;
                        break;
                    }
                    case INT: {
                        int ivalue = ((IntValueHolder)metrics).getValue();
                        int iexpected = RunningRule.this.threshold.getIntThreshold();
                        if (!RunningRule.this.op.test(iexpected, ivalue)) break;
                        ++matchCount;
                        break;
                    }
                    case DOUBLE: {
                        double dvalue = ((DoubleValueHolder)metrics).getValue();
                        double dexpected = RunningRule.this.threshold.getDoubleThreshold();
                        if (!RunningRule.this.op.test(dexpected, dvalue)) break;
                        ++matchCount;
                        break;
                    }
                    case MULTI_INTS: {
                        int ivalue;
                        int[] ivalueArray = ((MultiIntValuesHolder)metrics).getValues();
                        Integer[] iaexpected = RunningRule.this.threshold.getIntValuesThreshold();
                        if (log.isTraceEnabled()) {
                            log.trace("Value array is {}, expected array is {}", (Object)ivalueArray, (Object)iaexpected);
                        }
                        for (int i = 0; i < ivalueArray.length; ++i) {
                            ivalue = ivalueArray[i];
                            Integer iNullableExpected = 0;
                            if (iaexpected.length > i && (iNullableExpected = iaexpected[i]) == null || !RunningRule.this.op.test(iNullableExpected, ivalue)) continue;
                            if (log.isTraceEnabled()) {
                                log.trace("Matched, expected {}, value {}", (Object)iNullableExpected, (Object)ivalue);
                            }
                            ++matchCount;
                            break block0;
                        }
                        continue block7;
                    }
                    case LABELED_LONG: {
                        DataTable values = ((LabeledValueHolder)metrics).getValue();
                        long lexpected = RunningRule.this.threshold.getLongThreshold();
                        if (!values.keys().stream().anyMatch(label -> RunningRule.this.validate(label, RunningRule.this.includeLabels, RunningRule.this.excludeLabels, RunningRule.this.includeLabelsRegex, RunningRule.this.excludeLabelsRegex) && RunningRule.this.op.test(lexpected, values.get(label)))) break;
                        ++matchCount;
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Match count is {}, threshold is {}", (Object)matchCount, (Object)RunningRule.this.countThreshold);
            }
            return matchCount >= RunningRule.this.countThreshold;
        }

        private void init() {
            this.values = new LinkedList();
            for (int i = 0; i < this.period; ++i) {
                this.values.add(null);
            }
        }
    }
}

