/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.Objects;

public enum OP {
    GREATER{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() > Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    GREATER_EQ{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() >= Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    LESS{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() < Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    LESS_EQ{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() <= Objects.requireNonNull(expected, "expected").doubleValue();
        }
    }
    ,
    EQUAL{

        @Override
        public boolean test(Number expected, Number actual) {
            return Objects.requireNonNull(actual, "actual").doubleValue() == Objects.requireNonNull(expected, "expected").doubleValue();
        }
    };


    public static OP get(String op) {
        switch (op) {
            case ">": {
                return GREATER;
            }
            case ">=": {
                return GREATER_EQ;
            }
            case "<": {
                return LESS;
            }
            case "<=": {
                return LESS_EQ;
            }
            case "==": {
                return EQUAL;
            }
        }
        throw new IllegalArgumentException("unknown op, " + op);
    }

    public abstract boolean test(Number var1, Number var2);
}

