/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.NamespacedPodListInformer;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.UidEnvSupplier;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesCoordinator.class);
    private final ModuleDefineHolder manager;
    private final String uid;
    private volatile int port = -1;
    private HealthCheckMetrics healthChecker;

    public KubernetesCoordinator(ModuleDefineHolder manager, ClusterModuleKubernetesConfig config) {
        this.uid = new UidEnvSupplier(config.getUidEnvName()).get();
        this.manager = manager;
    }

    public List<RemoteInstance> queryRemoteNodes() {
        try {
            this.initHealthChecker();
            List pods = NamespacedPodListInformer.INFORMER.listPods().orElseGet(this::selfPod);
            if (log.isDebugEnabled()) {
                List uidList = pods.stream().map(item -> item.getMetadata().getUid()).collect(Collectors.toList());
                log.debug("[kubernetes cluster pods uid list]:{}", (Object)uidList.toString());
            }
            if (this.port == -1) {
                this.port = ((ConfigService)this.manager.find("core").provider().getService(ConfigService.class)).getGRPCPort();
            }
            List<RemoteInstance> remoteInstances = pods.stream().filter(pod -> StringUtil.isNotBlank((String)pod.getStatus().getPodIP())).map(pod -> new RemoteInstance(new Address(pod.getStatus().getPodIP(), this.port, pod.getMetadata().getUid().equals(this.uid)))).collect(Collectors.toList());
            this.healthChecker.health();
            return remoteInstances;
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            this.initHealthChecker();
            this.port = remoteInstance.getAddress().getPort();
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_k8s", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }

    private List<V1Pod> selfPod() {
        V1Pod v1Pod = new V1Pod();
        v1Pod.setMetadata(new V1ObjectMeta());
        v1Pod.setStatus(new V1PodStatus());
        v1Pod.getMetadata().setUid(this.uid);
        v1Pod.getStatus().setPodIP("127.0.0.1");
        return Collections.singletonList(v1Pod);
    }
}

