/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.event.rest;

import com.linecorp.armeria.server.annotation.Post;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.oap.server.analyzer.event.EventAnalyzerService;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRestServiceHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventRestServiceHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final EventAnalyzerService eventAnalyzerService;

    public EventRestServiceHandler(ModuleManager manager) {
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.eventAnalyzerService = (EventAnalyzerService)manager.find("event-analyzer").provider().getService(EventAnalyzerService.class);
        this.histogram = metricsCreator.createHistogramMetric("event_in_latency", "The process latency of event data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("event_error_count", "The error number of event analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Post(value="/v3/events")
    public Commands collectEvents(List<Event> events) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            events.forEach(e -> {
                if (e.getLayer().isEmpty()) {
                    throw new IllegalArgumentException("layer field is required since v9.0.0, please upgrade your event report tools");
                }
                Layer.nameOf((String)e.getLayer());
                this.eventAnalyzerService.analyze(e);
            });
            Commands commands = Commands.newBuilder().build();
            return commands;
        }
        catch (Exception e2) {
            this.errorCounter.inc();
            throw e2;
        }
    }
}

