/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.meter.provider.handler;

import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterDataCollection;
import org.apache.skywalking.apm.network.language.agent.v3.MeterReportServiceGrpc;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.IMeterProcessService;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.MeterProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterServiceHandler
extends MeterReportServiceGrpc.MeterReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeterServiceHandler.class);
    private final IMeterProcessService processService;
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;

    public MeterServiceHandler(ModuleManager manager, IMeterProcessService processService) {
        this.processService = processService;
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("meter_in_latency", "The process latency of meter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("meter_analysis_error_count", "The error number of meter analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
    }

    public StreamObserver<MeterData> collect(final StreamObserver<Commands> responseObserver) {
        final MeterProcessor processor = this.processService.createProcessor();
        return new StreamObserver<MeterData>(){

            public void onNext(MeterData meterData) {
                try (HistogramMetrics.Timer ignored = MeterServiceHandler.this.histogram.createTimer();){
                    processor.read(meterData);
                }
                catch (Exception e) {
                    MeterServiceHandler.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }

            public void onError(Throwable throwable) {
                processor.process();
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                processor.process();
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    public StreamObserver<MeterDataCollection> collectBatch(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<MeterDataCollection>(){

            public void onNext(MeterDataCollection meterDataCollection) {
                MeterProcessor processor = MeterServiceHandler.this.processService.createProcessor();
                try (HistogramMetrics.Timer ignored = MeterServiceHandler.this.histogram.createTimer();){
                    meterDataCollection.getMeterDataList().forEach(arg_0 -> ((MeterProcessor)processor).read(arg_0));
                    processor.process();
                }
                catch (Exception e) {
                    MeterServiceHandler.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }

            public void onError(Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

