/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.otlp;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.opentelemetry.proto.collector.metrics.v1.MetricsServiceGrpc;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.vavr.Function1;
import io.vavr.control.Try;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.prometheus.PrometheusMetricConverter;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryMetricHandler
extends MetricsServiceGrpc.MetricsServiceImplBase
implements Handler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryMetricHandler.class);
    private static final Map<String, String> LABEL_MAPPINGS = ImmutableMap.builder().put((Object)"net.host.name", (Object)"node_identifier_host_name").put((Object)"host.name", (Object)"node_identifier_host_name").put((Object)"job", (Object)"job_name").put((Object)"service.name", (Object)"job_name").build();
    private List<PrometheusMetricConverter> converters;

    @Override
    public String type() {
        return "otlp";
    }

    @Override
    public void active(OtelMetricReceiverConfig config, MeterSystem service, GRPCHandlerRegister grpcHandlerRegister) throws ModuleStartException {
        List enabledRules = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)config.getEnabledOtelRules());
        List rules = Rules.loadRules((String)"otel-rules", (List)enabledRules);
        if (rules.isEmpty()) {
            return;
        }
        this.converters = rules.stream().map(r -> new PrometheusMetricConverter(r, service)).collect(Collectors.toList());
        grpcHandlerRegister.addHandler((BindableService)this);
    }

    public void export(ExportMetricsServiceRequest requests, StreamObserver<ExportMetricsServiceResponse> responseObserver) {
        requests.getResourceMetricsList().forEach(request -> {
            if (log.isDebugEnabled()) {
                log.debug("Resource attributes: {}", (Object)request.getResource().getAttributesList());
            }
            Map<String, String> nodeLabels = request.getResource().getAttributesList().stream().collect(Collectors.toMap(it -> LABEL_MAPPINGS.getOrDefault(it.getKey(), it.getKey()).replaceAll("\\.", "_"), it -> it.getValue().getStringValue(), (v1, v2) -> v1));
            this.converters.forEach(convert -> convert.toMeter(request.getScopeMetricsList().stream().flatMap(scopeMetrics -> scopeMetrics.getMetricsList().stream().flatMap(metric -> this.adaptMetrics(nodeLabels, (io.opentelemetry.proto.metrics.v1.Metric)metric)).map(Function1.liftTry(Function.identity())).flatMap(tryIt -> MetricConvert.log((Try)tryIt, (String)"Convert OTEL metric to prometheus metric")))));
        });
        responseObserver.onNext((Object)ExportMetricsServiceResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    private static Map<String, String> buildLabels(List<KeyValue> kvs) {
        return kvs.stream().collect(Collectors.toMap(KeyValue::getKey, it -> it.getValue().getStringValue()));
    }

    private static Map<String, String> mergeLabels(Map<String, String> nodeLabels, Map<String, String> pointLabels) {
        HashMap<String, String> result = new HashMap<String, String>(nodeLabels);
        result.putAll(pointLabels);
        return result;
    }

    private static Map<Double, Long> buildBuckets(List<Long> bucketCounts, List<Double> explicitBounds) {
        HashMap<Double, Long> result = new HashMap<Double, Long>();
        for (int i = 0; i < explicitBounds.size(); ++i) {
            result.put(explicitBounds.get(i), bucketCounts.get(i));
        }
        result.put(Double.POSITIVE_INFINITY, bucketCounts.get(explicitBounds.size()));
        return result;
    }

    private Stream<? extends Metric> adaptMetrics(Map<String, String> nodeLabels, io.opentelemetry.proto.metrics.v1.Metric metric) {
        if (metric.hasGauge()) {
            return metric.getGauge().getDataPointsList().stream().map(point -> new Gauge(metric.getName(), OpenTelemetryMetricHandler.mergeLabels(nodeLabels, OpenTelemetryMetricHandler.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasSum()) {
            Sum sum = metric.getSum();
            if (sum.getAggregationTemporality() != AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE) {
                return Stream.empty();
            }
            if (sum.getIsMonotonic()) {
                return sum.getDataPointsList().stream().map(point -> new Counter(metric.getName(), OpenTelemetryMetricHandler.mergeLabels(nodeLabels, OpenTelemetryMetricHandler.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
            }
            return sum.getDataPointsList().stream().map(point -> new Gauge(metric.getName(), OpenTelemetryMetricHandler.mergeLabels(nodeLabels, OpenTelemetryMetricHandler.buildLabels(point.getAttributesList())), point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt(), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasHistogram()) {
            return metric.getHistogram().getDataPointsList().stream().map(point -> new Histogram(metric.getName(), OpenTelemetryMetricHandler.mergeLabels(nodeLabels, OpenTelemetryMetricHandler.buildLabels(point.getAttributesList())), point.getCount(), point.getSum(), OpenTelemetryMetricHandler.buildBuckets(point.getBucketCountsList(), point.getExplicitBoundsList()), point.getTimeUnixNano() / 1000000L));
        }
        if (metric.hasSummary()) {
            return metric.getSummary().getDataPointsList().stream().map(point -> new Summary(metric.getName(), OpenTelemetryMetricHandler.mergeLabels(nodeLabels, OpenTelemetryMetricHandler.buildLabels(point.getAttributesList())), point.getCount(), point.getSum(), point.getQuantileValuesList().stream().collect(Collectors.toMap(SummaryDataPoint.ValueAtQuantile::getQuantile, SummaryDataPoint.ValueAtQuantile::getValue)), point.getTimeUnixNano() / 1000000L));
        }
        throw new UnsupportedOperationException("Unsupported type");
    }
}

