/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.oc;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.protobuf.Timestamp;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opencensus.proto.agent.common.v1.Node;
import io.opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest;
import io.opencensus.proto.agent.metrics.v1.ExportMetricsServiceResponse;
import io.opencensus.proto.agent.metrics.v1.MetricsServiceGrpc;
import io.opencensus.proto.metrics.v1.DistributionValue;
import io.opencensus.proto.metrics.v1.LabelKey;
import io.opencensus.proto.metrics.v1.LabelValue;
import io.opencensus.proto.metrics.v1.MetricDescriptor;
import io.opencensus.proto.metrics.v1.Point;
import io.opencensus.proto.metrics.v1.SummaryValue;
import io.opencensus.proto.metrics.v1.TimeSeries;
import io.opencensus.proto.resource.v1.Resource;
import io.vavr.Function1;
import io.vavr.Tuple;
import io.vavr.control.Try;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.prometheus.PrometheusMetricConverter;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rules;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;

public class OCMetricHandler
extends MetricsServiceGrpc.MetricsServiceImplBase
implements Handler {
    private static final String HOST_NAME_LABEL = "node_identifier_host_name";
    private List<PrometheusMetricConverter> converters;

    public StreamObserver<ExportMetricsServiceRequest> export(final StreamObserver<ExportMetricsServiceResponse> responseObserver) {
        return new StreamObserver<ExportMetricsServiceRequest>(){
            private Node node;
            private Map<String, String> nodeLabels = new HashMap<String, String>();
            private Resource resource;

            public void onNext(ExportMetricsServiceRequest request) {
                if (request.hasNode()) {
                    String name;
                    this.node = request.getNode();
                    this.nodeLabels.clear();
                    if (this.node.hasIdentifier() && StringUtil.isNotBlank((String)this.node.getIdentifier().getHostName())) {
                        this.nodeLabels.put(OCMetricHandler.HOST_NAME_LABEL, this.node.getIdentifier().getHostName());
                    }
                    if (!Strings.isNullOrEmpty((String)(name = this.node.getServiceInfo().getName()))) {
                        this.nodeLabels.put("job_name", name);
                    }
                }
                if (request.hasResource() && StringUtil.isBlank((String)this.nodeLabels.get(OCMetricHandler.HOST_NAME_LABEL))) {
                    this.resource = request.getResource();
                    if (StringUtil.isNotBlank((String)((String)this.resource.getLabelsMap().get("net.host.name")))) {
                        this.nodeLabels.put(OCMetricHandler.HOST_NAME_LABEL, (String)this.resource.getLabelsMap().get("net.host.name"));
                    }
                }
                OCMetricHandler.this.converters.forEach(m -> m.toMeter(request.getMetricsList().stream().flatMap(metric -> metric.getTimeseriesList().stream().map(timeSeries -> Tuple.of((Object)metric.getMetricDescriptor(), (Object)OCMetricHandler.buildLabelsFromNodeInfo(this.nodeLabels, OCMetricHandler.buildLabels(metric.getMetricDescriptor().getLabelKeysList(), timeSeries.getLabelValuesList())), (Object)timeSeries))).flatMap(t -> ((TimeSeries)t._3).getPointsList().stream().map(point -> Tuple.of((Object)t._1, (Object)t._2, (Object)point))).map(Function1.liftTry(t -> {
                    switch (((MetricDescriptor)t._1).getType()) {
                        case GAUGE_INT64: {
                            return new Gauge(((MetricDescriptor)t._1).getName(), (Map)t._2, (double)((Point)t._3).getInt64Value(), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                        case GAUGE_DOUBLE: {
                            return new Gauge(((MetricDescriptor)t._1).getName(), (Map)t._2, ((Point)t._3).getDoubleValue(), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                        case CUMULATIVE_INT64: {
                            return new Counter(((MetricDescriptor)t._1).getName(), (Map)t._2, (double)((Point)t._3).getInt64Value(), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                        case CUMULATIVE_DOUBLE: {
                            return new Counter(((MetricDescriptor)t._1).getName(), (Map)t._2, ((Point)t._3).getDoubleValue(), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                        case CUMULATIVE_DISTRIBUTION: {
                            return new Histogram(((MetricDescriptor)t._1).getName(), (Map)t._2, ((Point)t._3).getDistributionValue().getCount(), ((Point)t._3).getDistributionValue().getSum(), OCMetricHandler.buildBuckets(((Point)t._3).getDistributionValue()), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                        case SUMMARY: {
                            return new Summary(((MetricDescriptor)t._1).getName(), (Map)t._2, ((Point)t._3).getSummaryValue().getCount().getValue(), ((Point)t._3).getSummaryValue().getSum().getValue(), OCMetricHandler.buildQuantiles(((Point)t._3).getSummaryValue().getSnapshot()), OCMetricHandler.tsToMilli(((Point)t._3).getTimestamp()));
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported OC type:" + ((MetricDescriptor)t._1).getType());
                })).flatMap(tryIt -> MetricConvert.log((Try)tryIt, (String)"Convert OC metric to prometheus metric"))));
            }

            public void onError(Throwable throwable) {
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private static Map<String, String> buildLabels(List<LabelKey> keys, List<LabelValue> values) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keys.size(); ++i) {
            result.put(keys.get(i).getKey(), values.get(i).getValue());
        }
        return result;
    }

    private static Map<String, String> buildLabelsFromNodeInfo(Map<String, String> nodeLabels, Map<String, String> buildLabelsResult) {
        buildLabelsResult.putAll(nodeLabels);
        return buildLabelsResult;
    }

    private static Map<Double, Long> buildBuckets(DistributionValue distributionValue) {
        HashMap<Double, Long> result = new HashMap<Double, Long>();
        List bounds = distributionValue.getBucketOptions().getExplicit().getBoundsList();
        for (int i = 0; i < bounds.size(); ++i) {
            result.put((Double)bounds.get(i), distributionValue.getBuckets(i).getCount());
        }
        result.put(Double.POSITIVE_INFINITY, distributionValue.getBuckets(bounds.size()).getCount());
        return result;
    }

    private static Map<Double, Double> buildQuantiles(SummaryValue.Snapshot snapshot) {
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        snapshot.getPercentileValuesList().forEach(p -> result.put(p.getPercentile(), p.getValue()));
        return result;
    }

    private static long tsToMilli(Timestamp timestamp) {
        return timestamp.equals((Object)Timestamp.getDefaultInstance()) ? System.currentTimeMillis() : Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()).toEpochMilli();
    }

    @Override
    public String type() {
        return "oc";
    }

    @Override
    public void active(OtelMetricReceiverConfig config, MeterSystem meterSystem, GRPCHandlerRegister grpcHandlerRegister) throws ModuleStartException {
        List enabledRules = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)config.getEnabledOtelRules());
        List rules = Rules.loadRules((String)"otel-rules", (List)enabledRules);
        if (rules.isEmpty()) {
            return;
        }
        this.converters = rules.stream().map(r -> new PrometheusMetricConverter(r, meterSystem)).collect(Collectors.toList());
        grpcHandlerRegister.addHandler((BindableService)this);
    }
}

