/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverModule;

public class OtelMetricReceiverProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private OtelMetricReceiverConfig config;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return OtelMetricReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        this.config = new OtelMetricReceiverConfig();
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (this.config.getEnabledHandlers().isEmpty()) {
            return;
        }
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        MeterSystem meterSystem = (MeterSystem)this.getManager().find("core").provider().getService(MeterSystem.class);
        List handlers = Handler.all().stream().filter(h -> this.config.getEnabledHandlers().contains(h.type())).collect(Collectors.toList());
        for (Handler h2 : handlers) {
            h2.active(this.config, meterSystem, grpcHandlerRegister);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"receiver-sharing-server"};
    }
}

