/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.otel.HandlerInitializationException;
import org.apache.skywalking.oap.server.receiver.otel.OtelMetricReceiverConfig;

public interface Handler {
    public static List<Handler> all() throws HandlerInitializationException {
        ClassPath classpath;
        try {
            classpath = ClassPath.from((ClassLoader)Handler.class.getClassLoader());
        }
        catch (IOException e) {
            throw new HandlerInitializationException("failed to load handler classes", e);
        }
        ImmutableSet classes = classpath.getTopLevelClassesRecursive(Handler.class.getPackage().getName());
        ArrayList<Handler> result = new ArrayList<Handler>();
        for (ClassPath.ClassInfo each : classes) {
            Class c = each.load();
            if (!Arrays.stream(c.getInterfaces()).anyMatch(interfaceClass -> interfaceClass.isAssignableFrom(Handler.class))) continue;
            try {
                result.add((Handler)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new HandlerInitializationException("failed to get instances of handler classed", e);
            }
        }
        return result;
    }

    public String type();

    public void active(OtelMetricReceiverConfig var1, MeterSystem var2, GRPCHandlerRegister var3) throws ModuleStartException;
}

