/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.tool.profile.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskQueryService;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.tool.profile.exporter.ExporterConfig;
import org.yaml.snakeyaml.Yaml;

public class ProfiledBasicInfo {
    public static final int SEQUENCE_RANGE_BATCH_SIZE = 500;
    private ExporterConfig config;
    private String segmentId;
    private long segmentStartTime;
    private long segmentEndTime;
    private int duration;
    private List<Span> profiledSegmentSpans;
    private int minSequence;
    private int maxSequence;

    public static ProfiledBasicInfo build(ExporterConfig config, ModuleManager manager) throws IOException {
        ProfiledBasicInfo data = new ProfiledBasicInfo();
        data.setConfig(config);
        ProfileTaskQueryService taskQueryService = (ProfileTaskQueryService)manager.find("core").provider().getService(ProfileTaskQueryService.class);
        TraceQueryService traceQueryService = (TraceQueryService)manager.find("core").provider().getService(TraceQueryService.class);
        IProfileThreadSnapshotQueryDAO threadSnapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)manager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        List taskTraces = taskQueryService.getTaskTraces(config.getTaskId());
        BasicTrace profiledTrace = taskTraces.stream().filter(t -> t.getTraceIds().contains(config.getTraceId())).findFirst().orElse(null);
        if (profiledTrace == null) {
            throw new IllegalArgumentException("Cannot fount profiled segment in current task: " + config.getTaskId() + ", segment id: " + config.getTraceId() + ", current task total profiled trace count is " + taskTraces.size());
        }
        String segmentId = profiledTrace.getSegmentId();
        long startTime = Long.parseLong(profiledTrace.getStart());
        long endTime = startTime + (long)profiledTrace.getDuration();
        data.setSegmentId(segmentId);
        data.setSegmentStartTime(startTime);
        data.setSegmentEndTime(endTime);
        data.setDuration(profiledTrace.getDuration());
        Trace trace = traceQueryService.queryTrace(config.getTraceId());
        List<Span> profiledSegmentSpans = trace.getSpans().stream().filter(s -> Objects.equals(s.getSegmentId(), segmentId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(profiledSegmentSpans)) {
            throw new IllegalArgumentException("Current segment cannot found any span");
        }
        data.setProfiledSegmentSpans(profiledSegmentSpans);
        int minSequence = threadSnapshotQueryDAO.queryMinSequence(segmentId, startTime, endTime);
        int maxSequence = threadSnapshotQueryDAO.queryMaxSequence(segmentId, startTime, endTime);
        data.setMinSequence(minSequence);
        data.setMaxSequence(maxSequence);
        return data;
    }

    public File writeFile() throws IOException {
        String serialData = new Yaml().dump((Object)this);
        File file = new File(this.config.getAnalyzeResultDist() + File.separator + "basic.yml");
        FileUtils.write((File)file, (CharSequence)serialData, (String)"UTF-8");
        return file;
    }

    public static ProfiledBasicInfo parseFormFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ProfiledBasicInfo profiledBasicInfo = (ProfiledBasicInfo)new Yaml().loadAs((InputStream)fileInputStream, ProfiledBasicInfo.class);
            return profiledBasicInfo;
        }
    }

    public List<SequenceRange> buildSequenceRanges() {
        ArrayList<SequenceRange> ranges = new ArrayList<SequenceRange>();
        do {
            int batchMax = Math.min(this.minSequence + 500, this.maxSequence);
            ranges.add(new SequenceRange(this.minSequence, batchMax));
            this.minSequence = batchMax;
        } while (this.minSequence < this.maxSequence);
        return ranges;
    }

    @Generated
    public ProfiledBasicInfo() {
    }

    @Generated
    public ExporterConfig getConfig() {
        return this.config;
    }

    @Generated
    public String getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public long getSegmentStartTime() {
        return this.segmentStartTime;
    }

    @Generated
    public long getSegmentEndTime() {
        return this.segmentEndTime;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public List<Span> getProfiledSegmentSpans() {
        return this.profiledSegmentSpans;
    }

    @Generated
    public int getMinSequence() {
        return this.minSequence;
    }

    @Generated
    public int getMaxSequence() {
        return this.maxSequence;
    }

    @Generated
    public void setConfig(ExporterConfig config) {
        this.config = config;
    }

    @Generated
    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public void setSegmentStartTime(long segmentStartTime) {
        this.segmentStartTime = segmentStartTime;
    }

    @Generated
    public void setSegmentEndTime(long segmentEndTime) {
        this.segmentEndTime = segmentEndTime;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setProfiledSegmentSpans(List<Span> profiledSegmentSpans) {
        this.profiledSegmentSpans = profiledSegmentSpans;
    }

    @Generated
    public void setMinSequence(int minSequence) {
        this.minSequence = minSequence;
    }

    @Generated
    public void setMaxSequence(int maxSequence) {
        this.maxSequence = maxSequence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfiledBasicInfo)) {
            return false;
        }
        ProfiledBasicInfo other = (ProfiledBasicInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSegmentStartTime() != other.getSegmentStartTime()) {
            return false;
        }
        if (this.getSegmentEndTime() != other.getSegmentEndTime()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getMinSequence() != other.getMinSequence()) {
            return false;
        }
        if (this.getMaxSequence() != other.getMaxSequence()) {
            return false;
        }
        ExporterConfig this$config = this.getConfig();
        ExporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$segmentId = this.getSegmentId();
        String other$segmentId = other.getSegmentId();
        if (this$segmentId == null ? other$segmentId != null : !this$segmentId.equals(other$segmentId)) {
            return false;
        }
        List<Span> this$profiledSegmentSpans = this.getProfiledSegmentSpans();
        List<Span> other$profiledSegmentSpans = other.getProfiledSegmentSpans();
        return !(this$profiledSegmentSpans == null ? other$profiledSegmentSpans != null : !((Object)this$profiledSegmentSpans).equals(other$profiledSegmentSpans));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProfiledBasicInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $segmentStartTime = this.getSegmentStartTime();
        result = result * 59 + (int)($segmentStartTime >>> 32 ^ $segmentStartTime);
        long $segmentEndTime = this.getSegmentEndTime();
        result = result * 59 + (int)($segmentEndTime >>> 32 ^ $segmentEndTime);
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getMinSequence();
        result = result * 59 + this.getMaxSequence();
        ExporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $segmentId = this.getSegmentId();
        result = result * 59 + ($segmentId == null ? 43 : $segmentId.hashCode());
        List<Span> $profiledSegmentSpans = this.getProfiledSegmentSpans();
        result = result * 59 + ($profiledSegmentSpans == null ? 43 : ((Object)$profiledSegmentSpans).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProfiledBasicInfo(config=" + this.getConfig() + ", segmentId=" + this.getSegmentId() + ", segmentStartTime=" + this.getSegmentStartTime() + ", segmentEndTime=" + this.getSegmentEndTime() + ", duration=" + this.getDuration() + ", profiledSegmentSpans=" + this.getProfiledSegmentSpans() + ", minSequence=" + this.getMinSequence() + ", maxSequence=" + this.getMaxSequence() + ")";
    }

    public static class SequenceRange {
        private int min;
        private int max;

        public SequenceRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Generated
        public int getMin() {
            return this.min;
        }

        @Generated
        public int getMax() {
            return this.max;
        }
    }
}

