/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.tool.profile.exporter;

import java.io.File;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.starter.config.ApplicationConfigLoader;
import org.apache.skywalking.oap.server.tool.profile.exporter.ExporterConfig;
import org.apache.skywalking.oap.server.tool.profile.exporter.ProfileSnapshotDumper;
import org.apache.skywalking.oap.server.tool.profile.exporter.ProfiledBasicInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSnapshotExporterBootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileSnapshotExporterBootstrap.class);

    public static void export(String[] args) {
        ApplicationConfigLoader configLoader = new ApplicationConfigLoader();
        ModuleManager manager = new ModuleManager();
        try {
            ExporterConfig exporterConfig = ExporterConfig.parse(args);
            exporterConfig.init();
            ApplicationConfiguration applicationConfiguration = configLoader.load();
            manager.init(applicationConfiguration);
            ProfiledBasicInfo profiledBaseInfo = ProfiledBasicInfo.build(exporterConfig, manager);
            log.info("Queried profiled basic info, profiled segment start time:{}, duration:{}, total span count:{}, snapshot count:{}", new Object[]{profiledBaseInfo.getSegmentStartTime(), profiledBaseInfo.getDuration(), profiledBaseInfo.getProfiledSegmentSpans().size(), profiledBaseInfo.getMaxSequence() - profiledBaseInfo.getMinSequence()});
            File basicInfoFile = profiledBaseInfo.writeFile();
            log.info("Write segment info to file:{}", (Object)basicInfoFile.getAbsolutePath());
            File snapshotFile = ProfileSnapshotDumper.dump(profiledBaseInfo, manager);
            log.info("Write snapshot to file:{}", (Object)snapshotFile);
            System.exit(0);
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            System.exit(1);
        }
    }
}

