/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.nacos;

import com.alibaba.nacos.api.naming.NamingService;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.cluster.plugin.nacos.ClusterModuleNacosConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class NacosCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private final ModuleDefineHolder manager;
    private final NamingService namingService;
    private final ClusterModuleNacosConfig config;
    private volatile Address selfAddress;
    private HealthCheckMetrics healthChecker;

    public NacosCoordinator(ModuleDefineHolder manager, NamingService namingService, ClusterModuleNacosConfig config) {
        this.manager = manager;
        this.namingService = namingService;
        this.config = config;
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>();
        try {
            ClusterHealthStatus healthStatus;
            this.initHealthChecker();
            List instances = this.namingService.selectInstances(this.config.getServiceName(), true);
            if (CollectionUtils.isNotEmpty((List)instances)) {
                instances.forEach(instance -> {
                    Address address = new Address(instance.getIp(), instance.getPort(), false);
                    if (address.equals((Object)this.selfAddress)) {
                        address.setSelf(true);
                    }
                    remoteInstances.add(new RemoteInstance(address));
                });
            }
            if ((healthStatus = OAPNodeChecker.isHealth(remoteInstances)).isHealth()) {
                this.healthChecker.health();
            } else {
                this.healthChecker.unHealth(healthStatus.getReason());
            }
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
        return remoteInstances;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        if (this.needUsingInternalAddr()) {
            remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
        }
        String host = remoteInstance.getAddress().getHost();
        int port = remoteInstance.getAddress().getPort();
        try {
            this.initHealthChecker();
            this.namingService.registerInstance(this.config.getServiceName(), host, port);
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
        this.selfAddress = remoteInstance.getAddress();
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_nacos", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }
}

