/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.jdbc.hikaricp;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCHikariCPClient
implements Client,
HealthCheckable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCHikariCPClient.class);
    private final HikariConfig hikariConfig;
    private final DelegatedHealthChecker healthChecker;
    private HikariDataSource dataSource;

    public JDBCHikariCPClient(Properties properties) {
        this.hikariConfig = new HikariConfig(properties);
        this.healthChecker = new DelegatedHealthChecker();
    }

    @Override
    public void connect() {
        this.dataSource = new HikariDataSource(this.hikariConfig);
    }

    @Override
    public void shutdown() {
        this.dataSource.close();
    }

    public Connection getConnection() throws JDBCClientException {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean autoCommit) throws JDBCClientException {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException e) {
            throw new JDBCClientException(e.getMessage(), e);
        }
    }

    public void execute(Connection connection, String sql) throws JDBCClientException {
        LOGGER.debug("execute sql: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
            this.healthChecker.health();
        }
        catch (SQLException e) {
            this.healthChecker.unHealth(e);
            throw new JDBCClientException(e.getMessage(), e);
        }
    }

    public int executeUpdate(Connection connection, String sql, Object ... params) throws JDBCClientException {
        int result;
        LOGGER.debug("execute query with result: {}", (Object)sql);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            this.setStatementParam(statement, params);
            result = statement.executeUpdate();
            statement.closeOnCompletion();
            this.healthChecker.health();
        }
        catch (SQLException e) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.healthChecker.unHealth(e);
            throw new JDBCClientException(e.getMessage(), e);
        }
        return result;
    }

    public ResultSet executeQuery(Connection connection, String sql, Object ... params) throws JDBCClientException {
        ResultSet rs;
        LOGGER.debug("execute query with result: {}", (Object)sql);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            this.setStatementParam(statement, params);
            rs = statement.executeQuery();
            statement.closeOnCompletion();
            this.healthChecker.health();
        }
        catch (SQLException e) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.healthChecker.unHealth(e);
            throw new JDBCClientException(e.getMessage(), e);
        }
        return rs;
    }

    private void setStatementParam(PreparedStatement statement, Object[] params) throws SQLException, JDBCClientException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof String) {
                    statement.setString(i + 1, (String)param);
                    continue;
                }
                if (param instanceof Integer) {
                    statement.setInt(i + 1, (Integer)param);
                    continue;
                }
                if (param instanceof Double) {
                    statement.setDouble(i + 1, (Double)param);
                    continue;
                }
                if (param instanceof Long) {
                    statement.setLong(i + 1, (Long)param);
                    continue;
                }
                throw new JDBCClientException("Unsupported data type, type=" + param.getClass().getName());
            }
        }
    }

    @Override
    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }
}

