/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.zipkin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@SuperDataset
@Stream(name="zipkin_span", scopeId=23, builder=Builder.class, processor=RecordStreamProcessor.class)
@SQLDatabase.ExtraColumn4AdditionalEntity(additionalTable="zipkin_query", parentColumn="time_bucket")
public class ZipkinSpanRecord
extends Record {
    private static final Gson GSON = new Gson();
    public static final String INDEX_NAME = "zipkin_span";
    public static final String ADDITIONAL_QUERY_TABLE = "zipkin_query";
    public static final String TRACE_ID = "trace_id";
    public static final String SPAN_ID = "span_id";
    public static final String PARENT_ID = "parent_id";
    public static final String NAME = "name";
    public static final String DURATION = "duration";
    public static final String KIND = "kind";
    public static final String TIMESTAMP_MILLIS = "timestamp_millis";
    public static final String TIMESTAMP = "timestamp";
    public static final String LOCAL_ENDPOINT_SERVICE_NAME = "local_endpoint_service_name";
    public static final String LOCAL_ENDPOINT_IPV4 = "local_endpoint_ipv4";
    public static final String LOCAL_ENDPOINT_IPV6 = "local_endpoint_ipv6";
    public static final String LOCAL_ENDPOINT_PORT = "local_endpoint_port";
    public static final String REMOTE_ENDPOINT_SERVICE_NAME = "remote_endpoint_service_name";
    public static final String REMOTE_ENDPOINT_IPV4 = "remote_endpoint_ipv4";
    public static final String REMOTE_ENDPOINT_IPV6 = "remote_endpoint_ipv6";
    public static final String REMOTE_ENDPOINT_PORT = "remote_endpoint_port";
    public static final String ANNOTATIONS = "annotations";
    public static final String TAGS = "tags";
    public static final String DEBUG = "debug";
    public static final String SHARED = "shared";
    public static final String QUERY = "query";
    @Column(columnName="trace_id")
    private String traceId;
    @Column(columnName="span_id")
    private String spanId;
    @Column(columnName="parent_id")
    private String parentId;
    @Column(columnName="name")
    private String name;
    @Column(columnName="duration")
    private long duration;
    @Column(columnName="kind")
    private String kind;
    @Column(columnName="timestamp_millis")
    private long timestampMillis;
    @Column(columnName="timestamp")
    private long timestamp;
    @Column(columnName="local_endpoint_service_name")
    @BanyanDB.ShardingKey(index=0)
    private String localEndpointServiceName;
    @Column(columnName="local_endpoint_ipv4", storageOnly=true)
    private String localEndpointIPV4;
    @Column(columnName="local_endpoint_ipv6", storageOnly=true)
    private String localEndpointIPV6;
    @Column(columnName="local_endpoint_port", storageOnly=true)
    private int localEndpointPort;
    @Column(columnName="remote_endpoint_service_name")
    private String remoteEndpointServiceName;
    @Column(columnName="remote_endpoint_ipv4", storageOnly=true)
    private String remoteEndpointIPV4;
    @Column(columnName="remote_endpoint_ipv6", storageOnly=true)
    private String remoteEndpointIPV6;
    @Column(columnName="remote_endpoint_port", storageOnly=true)
    private int remoteEndpointPort;
    @Column(columnName="annotations", storageOnly=true, length=50000)
    private JsonObject annotations;
    @Column(columnName="tags", storageOnly=true, length=50000)
    private JsonObject tags;
    @Column(columnName="debug")
    private int debug;
    @Column(columnName="shared")
    private int shared;
    @Column(columnName="query", indexOnly=true)
    @SQLDatabase.AdditionalEntity(additionalTables={"zipkin_query"})
    private List<String> query;

    @Override
    public String id() {
        return this.spanId + "-" + this.kind;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    @Generated
    public String getSpanId() {
        return this.spanId;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Generated
    public String getKind() {
        return this.kind;
    }

    @Generated
    public void setTimestampMillis(long timestampMillis) {
        this.timestampMillis = timestampMillis;
    }

    @Generated
    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setLocalEndpointServiceName(String localEndpointServiceName) {
        this.localEndpointServiceName = localEndpointServiceName;
    }

    @Generated
    public String getLocalEndpointServiceName() {
        return this.localEndpointServiceName;
    }

    @Generated
    public void setLocalEndpointIPV4(String localEndpointIPV4) {
        this.localEndpointIPV4 = localEndpointIPV4;
    }

    @Generated
    public String getLocalEndpointIPV4() {
        return this.localEndpointIPV4;
    }

    @Generated
    public void setLocalEndpointIPV6(String localEndpointIPV6) {
        this.localEndpointIPV6 = localEndpointIPV6;
    }

    @Generated
    public String getLocalEndpointIPV6() {
        return this.localEndpointIPV6;
    }

    @Generated
    public void setLocalEndpointPort(int localEndpointPort) {
        this.localEndpointPort = localEndpointPort;
    }

    @Generated
    public int getLocalEndpointPort() {
        return this.localEndpointPort;
    }

    @Generated
    public void setRemoteEndpointServiceName(String remoteEndpointServiceName) {
        this.remoteEndpointServiceName = remoteEndpointServiceName;
    }

    @Generated
    public String getRemoteEndpointServiceName() {
        return this.remoteEndpointServiceName;
    }

    @Generated
    public void setRemoteEndpointIPV4(String remoteEndpointIPV4) {
        this.remoteEndpointIPV4 = remoteEndpointIPV4;
    }

    @Generated
    public String getRemoteEndpointIPV4() {
        return this.remoteEndpointIPV4;
    }

    @Generated
    public void setRemoteEndpointIPV6(String remoteEndpointIPV6) {
        this.remoteEndpointIPV6 = remoteEndpointIPV6;
    }

    @Generated
    public String getRemoteEndpointIPV6() {
        return this.remoteEndpointIPV6;
    }

    @Generated
    public void setRemoteEndpointPort(int remoteEndpointPort) {
        this.remoteEndpointPort = remoteEndpointPort;
    }

    @Generated
    public int getRemoteEndpointPort() {
        return this.remoteEndpointPort;
    }

    @Generated
    public void setAnnotations(JsonObject annotations) {
        this.annotations = annotations;
    }

    @Generated
    public JsonObject getAnnotations() {
        return this.annotations;
    }

    @Generated
    public void setTags(JsonObject tags) {
        this.tags = tags;
    }

    @Generated
    public JsonObject getTags() {
        return this.tags;
    }

    @Generated
    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Generated
    public int getDebug() {
        return this.debug;
    }

    @Generated
    public void setShared(int shared) {
        this.shared = shared;
    }

    @Generated
    public int getShared() {
        return this.shared;
    }

    @Generated
    public void setQuery(List<String> query) {
        this.query = query;
    }

    @Generated
    public List<String> getQuery() {
        return this.query;
    }

    public static class Builder
    implements StorageBuilder<ZipkinSpanRecord> {
        @Override
        public ZipkinSpanRecord storage2Entity(Convert2Entity converter) {
            String tagsString;
            String annotationsString;
            ZipkinSpanRecord record = new ZipkinSpanRecord();
            record.setTraceId((String)converter.get(ZipkinSpanRecord.TRACE_ID));
            record.setSpanId((String)converter.get(ZipkinSpanRecord.SPAN_ID));
            record.setParentId((String)converter.get(ZipkinSpanRecord.PARENT_ID));
            record.setName((String)converter.get(ZipkinSpanRecord.NAME));
            record.setKind((String)converter.get(ZipkinSpanRecord.KIND));
            record.setTimestamp(((Number)converter.get(ZipkinSpanRecord.TIMESTAMP)).longValue());
            record.setTimestampMillis(((Number)converter.get(ZipkinSpanRecord.TIMESTAMP_MILLIS)).longValue());
            record.setDuration(((Number)converter.get(ZipkinSpanRecord.DURATION)).longValue());
            record.setLocalEndpointServiceName((String)converter.get(ZipkinSpanRecord.LOCAL_ENDPOINT_SERVICE_NAME));
            record.setLocalEndpointIPV4((String)converter.get(ZipkinSpanRecord.LOCAL_ENDPOINT_IPV4));
            record.setLocalEndpointIPV6((String)converter.get(ZipkinSpanRecord.LOCAL_ENDPOINT_IPV6));
            if (converter.get(ZipkinSpanRecord.LOCAL_ENDPOINT_PORT) != null) {
                record.setLocalEndpointPort(((Number)converter.get(ZipkinSpanRecord.LOCAL_ENDPOINT_PORT)).intValue());
            }
            record.setRemoteEndpointServiceName((String)converter.get(ZipkinSpanRecord.REMOTE_ENDPOINT_SERVICE_NAME));
            record.setRemoteEndpointIPV4((String)converter.get(ZipkinSpanRecord.REMOTE_ENDPOINT_IPV4));
            record.setRemoteEndpointIPV6((String)converter.get(ZipkinSpanRecord.REMOTE_ENDPOINT_IPV6));
            if (converter.get(ZipkinSpanRecord.REMOTE_ENDPOINT_PORT) != null) {
                record.setRemoteEndpointPort(((Number)converter.get(ZipkinSpanRecord.REMOTE_ENDPOINT_PORT)).intValue());
            }
            if (StringUtil.isNotEmpty((String)(annotationsString = (String)converter.get(ZipkinSpanRecord.ANNOTATIONS)))) {
                record.setAnnotations((JsonObject)GSON.fromJson(annotationsString, JsonObject.class));
            }
            if (StringUtil.isNotEmpty((String)(tagsString = (String)converter.get(ZipkinSpanRecord.TAGS)))) {
                record.setTags((JsonObject)GSON.fromJson(tagsString, JsonObject.class));
            }
            if (converter.get(ZipkinSpanRecord.DEBUG) != null) {
                record.setDebug(((Number)converter.get(ZipkinSpanRecord.DEBUG)).intValue());
            }
            if (converter.get(ZipkinSpanRecord.SHARED) != null) {
                record.setShared(((Number)converter.get(ZipkinSpanRecord.SHARED)).intValue());
            }
            return record;
        }

        @Override
        public void entity2Storage(ZipkinSpanRecord storageData, Convert2Storage converter) {
            converter.accept(ZipkinSpanRecord.TRACE_ID, storageData.getTraceId());
            converter.accept(ZipkinSpanRecord.SPAN_ID, storageData.getSpanId());
            converter.accept(ZipkinSpanRecord.PARENT_ID, storageData.getParentId());
            converter.accept(ZipkinSpanRecord.NAME, storageData.getName());
            converter.accept(ZipkinSpanRecord.KIND, storageData.getKind());
            converter.accept(ZipkinSpanRecord.TIMESTAMP, storageData.getTimestamp());
            converter.accept(ZipkinSpanRecord.TIMESTAMP_MILLIS, storageData.getTimestampMillis());
            converter.accept(ZipkinSpanRecord.DURATION, storageData.getDuration());
            converter.accept(ZipkinSpanRecord.LOCAL_ENDPOINT_SERVICE_NAME, storageData.getLocalEndpointServiceName());
            converter.accept(ZipkinSpanRecord.LOCAL_ENDPOINT_IPV4, storageData.getLocalEndpointIPV4());
            converter.accept(ZipkinSpanRecord.LOCAL_ENDPOINT_IPV6, storageData.getLocalEndpointIPV6());
            if (storageData.getLocalEndpointPort() != 0) {
                converter.accept(ZipkinSpanRecord.LOCAL_ENDPOINT_PORT, storageData.getLocalEndpointPort());
            }
            converter.accept(ZipkinSpanRecord.REMOTE_ENDPOINT_SERVICE_NAME, storageData.getRemoteEndpointServiceName());
            converter.accept(ZipkinSpanRecord.REMOTE_ENDPOINT_IPV4, storageData.getRemoteEndpointIPV4());
            converter.accept(ZipkinSpanRecord.REMOTE_ENDPOINT_IPV6, storageData.getRemoteEndpointIPV6());
            if (storageData.getRemoteEndpointPort() != 0) {
                converter.accept(ZipkinSpanRecord.REMOTE_ENDPOINT_PORT, storageData.getRemoteEndpointPort());
            }
            if (storageData.getAnnotations() != null) {
                converter.accept(ZipkinSpanRecord.ANNOTATIONS, GSON.toJson((JsonElement)storageData.getAnnotations()));
            } else {
                converter.accept(ZipkinSpanRecord.ANNOTATIONS, "");
            }
            if (storageData.getTags() != null) {
                converter.accept(ZipkinSpanRecord.TAGS, GSON.toJson((JsonElement)storageData.getTags()));
            } else {
                converter.accept(ZipkinSpanRecord.TAGS, "");
            }
            converter.accept(ZipkinSpanRecord.QUERY, storageData.getQuery());
            if (storageData.getDebug() == BooleanUtils.booleanToValue((Boolean)true)) {
                converter.accept(ZipkinSpanRecord.DEBUG, storageData.getDebug());
            }
            if (storageData.getShared() == BooleanUtils.booleanToValue((Boolean)true)) {
                converter.accept(ZipkinSpanRecord.SHARED, storageData.getShared());
            }
        }
    }
}

