/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.ttl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.IModelManager;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataTTLKeeperTimer {
    INSTANCE;

    @Generated
    private static final Logger log;
    private ModuleManager moduleManager;
    private ClusterNodesQuery clusterNodesQuery;
    private CoreModuleConfig moduleConfig;

    public void start(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.clusterNodesQuery = (ClusterNodesQuery)moduleManager.find("cluster").provider().getService(ClusterNodesQuery.class);
        this.moduleConfig = moduleConfig;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(this::delete, t -> log.error("Remove data in background failure.", t)), moduleConfig.getDataKeeperExecutePeriod(), moduleConfig.getDataKeeperExecutePeriod(), TimeUnit.MINUTES);
    }

    private void delete() {
        IModelManager modelGetter = (IModelManager)this.moduleManager.find("core").provider().getService(IModelManager.class);
        List<Model> models = modelGetter.allModels();
        List<RemoteInstance> remoteInstances = this.clusterNodesQuery.queryRemoteNodes();
        if (CollectionUtils.isNotEmpty(remoteInstances) && !remoteInstances.get(0).getAddress().isSelf()) {
            log.info("The selected first getAddress is {}. The remove stage is skipped.", (Object)remoteInstances.get(0).toString());
            return;
        }
        log.info("Beginning to remove expired metrics from the storage.");
        models.forEach(this::execute);
    }

    private void execute(Model model) {
        try {
            if (!model.isTimeSeries()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Is record? {}. RecordDataTTL {}, MetricsDataTTL {}", new Object[]{model.isRecord(), this.moduleConfig.getRecordDataTTL(), this.moduleConfig.getMetricsDataTTL()});
            }
            ((IHistoryDeleteDAO)this.moduleManager.find("storage").provider().getService(IHistoryDeleteDAO.class)).deleteHistory(model, "time_bucket", model.isRecord() ? this.moduleConfig.getRecordDataTTL() : this.moduleConfig.getMetricsDataTTL());
        }
        catch (IOException e) {
            log.warn("History of {} delete failure", (Object)model.getName());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        log = LoggerFactory.getLogger(DataTTLKeeperTimer.class);
    }
}

