/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBExtension;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchExtension;
import org.apache.skywalking.oap.server.core.storage.model.IModelManager;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelManipulator;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseExtension;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageModels
implements IModelManager,
ModelCreator,
ModelManipulator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageModels.class);
    private final List<Model> models = new ArrayList<Model>();
    private final HashMap<String, String> columnNameOverrideRule = new HashMap();
    private final List<ModelCreator.CreatingListener> listeners = new ArrayList<ModelCreator.CreatingListener>();

    @Override
    public Model add(Class<?> aClass, int scopeId, Storage storage, boolean record) throws StorageException {
        DefaultScopeDefine.nameOf(scopeId);
        ArrayList<ModelColumn> modelColumns = new ArrayList<ModelColumn>();
        ShardingKeyChecker checker = new ShardingKeyChecker();
        SQLDatabaseModelExtension sqlDBModelExtension = new SQLDatabaseModelExtension();
        this.retrieval(aClass, storage.getModelName(), modelColumns, scopeId, checker, sqlDBModelExtension, record);
        if (aClass.isAnnotationPresent(SQLDatabase.ExtraColumn4AdditionalEntity.class) || aClass.isAnnotationPresent(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class)) {
            HashMap<String, List> extraColumns = new HashMap<String, List>();
            if (aClass.isAnnotationPresent(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class)) {
                for (SQLDatabase.ExtraColumn4AdditionalEntity extraColumn2 : aClass.getAnnotation(SQLDatabase.MultipleExtraColumn4AdditionalEntity.class).value()) {
                    List tables2 = extraColumns.computeIfAbsent(extraColumn2.parentColumn(), v -> new ArrayList());
                    tables2.add(extraColumn2.additionalTable());
                }
            } else {
                SQLDatabase.ExtraColumn4AdditionalEntity extraColumn3 = aClass.getAnnotation(SQLDatabase.ExtraColumn4AdditionalEntity.class);
                List tables3 = extraColumns.computeIfAbsent(extraColumn3.parentColumn(), v -> new ArrayList());
                tables3.add(extraColumn3.additionalTable());
            }
            extraColumns.forEach((extraColumn, tables) -> {
                if (!this.addExtraColumn4AdditionalEntity(sqlDBModelExtension, (List<ModelColumn>)modelColumns, (String)extraColumn, (List<String>)tables)) {
                    throw new IllegalStateException("Model [" + storage.getModelName() + "] defined an extra column  [" + extraColumn + "]  by @SQLDatabase.ExtraColumn4AdditionalEntity, but couldn't be found from the parent.");
                }
            });
        }
        checker.check(storage.getModelName());
        Model model = new Model(storage.getModelName(), modelColumns, scopeId, storage.getDownsampling(), record, this.isSuperDatasetModel(aClass), aClass, storage.isTimeRelativeID(), sqlDBModelExtension);
        this.followColumnNameRules(model);
        this.models.add(model);
        for (ModelCreator.CreatingListener listener : this.listeners) {
            listener.whenCreating(model);
        }
        return model;
    }

    private boolean isSuperDatasetModel(Class<?> aClass) {
        return aClass.isAnnotationPresent(SuperDataset.class);
    }

    @Override
    public void addModelListener(ModelCreator.CreatingListener listener) throws StorageException {
        this.listeners.add(listener);
        for (Model model : this.models) {
            listener.whenCreating(model);
        }
    }

    private void retrieval(Class<?> clazz, String modelName, List<ModelColumn> modelColumns, int scopeId, ShardingKeyChecker checker, SQLDatabaseModelExtension sqlDBModelExtension, boolean record) {
        Field[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Analysis {} to generate Model.", (Object)clazz.getName());
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            String envValue;
            if (!field.isAnnotationPresent(Column.class)) continue;
            if (field.isAnnotationPresent(SQLDatabase.AdditionalEntity.class) && !record) {
                throw new IllegalStateException("Model [" + modelName + "] is not a Record, @SQLDatabase.AdditionalEntity only supports Record.");
            }
            Column column = field.getAnnotation(Column.class);
            int columnLength = column.length();
            String lengthEnvVariable = column.lengthEnvVariable();
            if (StringUtil.isNotEmpty((String)lengthEnvVariable) && StringUtil.isNotEmpty((String)(envValue = System.getenv(lengthEnvVariable)))) {
                try {
                    columnLength = Integer.parseInt(envValue);
                }
                catch (NumberFormatException e) {
                    log.error("Model [{}] Column [{}], illegal value {} of column length from system env [{}]", new Object[]{modelName, column.columnName(), envValue, lengthEnvVariable});
                }
            }
            SQLDatabaseExtension sqlDatabaseExtension = new SQLDatabaseExtension();
            ArrayList<SQLDatabase.QueryUnifiedIndex> indexDefinitions = new ArrayList<SQLDatabase.QueryUnifiedIndex>();
            if (field.isAnnotationPresent(SQLDatabase.QueryUnifiedIndex.class)) {
                indexDefinitions.add(field.getAnnotation(SQLDatabase.QueryUnifiedIndex.class));
            }
            if (field.isAnnotationPresent(SQLDatabase.MultipleQueryUnifiedIndex.class)) {
                Collections.addAll(indexDefinitions, field.getAnnotation(SQLDatabase.MultipleQueryUnifiedIndex.class).value());
            }
            indexDefinitions.forEach(indexDefinition -> sqlDatabaseExtension.appendIndex(new SQLDatabaseExtension.MultiColumnsIndex(column.columnName(), indexDefinition.withColumns())));
            ElasticSearch.MatchQuery elasticSearchAnalyzer = field.getAnnotation(ElasticSearch.MatchQuery.class);
            ElasticSearch.Column elasticSearchColumn = field.getAnnotation(ElasticSearch.Column.class);
            ElasticSearchExtension elasticSearchExtension = new ElasticSearchExtension(elasticSearchAnalyzer == null ? null : elasticSearchAnalyzer.analyzer(), elasticSearchColumn == null ? null : elasticSearchColumn.columnAlias());
            BanyanDB.ShardingKey banyanDBShardingKey = field.getAnnotation(BanyanDB.ShardingKey.class);
            BanyanDB.GlobalIndex banyanDBGlobalIndex = field.getAnnotation(BanyanDB.GlobalIndex.class);
            BanyanDB.NoIndexing banyanDBNoIndex = field.getAnnotation(BanyanDB.NoIndexing.class);
            BanyanDBExtension banyanDBExtension = new BanyanDBExtension(banyanDBShardingKey == null ? -1 : banyanDBShardingKey.index(), banyanDBGlobalIndex != null, banyanDBNoIndex != null ? false : column.storageOnly());
            ModelColumn modelColumn = new ModelColumn(new ColumnName(modelName, column.columnName()), field.getType(), field.getGenericType(), column.storageOnly(), column.indexOnly(), column.dataType().isValue(), columnLength, sqlDatabaseExtension, elasticSearchExtension, banyanDBExtension);
            if (banyanDBExtension.isShardingKey()) {
                checker.accept(modelName, modelColumn);
            }
            if (field.isAnnotationPresent(SQLDatabase.AdditionalEntity.class)) {
                String[] tableNames;
                for (String tableName : tableNames = field.getAnnotation(SQLDatabase.AdditionalEntity.class).additionalTables()) {
                    sqlDBModelExtension.appendAdditionalTable(tableName, modelColumn);
                }
                if (!field.getAnnotation(SQLDatabase.AdditionalEntity.class).reserveOriginalColumns()) {
                    sqlDBModelExtension.appendExcludeColumns(modelColumn);
                }
            }
            modelColumns.add(modelColumn);
            if (log.isDebugEnabled()) {
                log.debug("The field named [{}] with the [{}] type", (Object)column.columnName(), field.getType());
            }
            if (!column.dataType().isValue()) continue;
            ValueColumnMetadata.INSTANCE.putIfAbsent(modelName, column.columnName(), column.dataType(), column.function(), column.defaultValue(), scopeId);
        }
        if (Objects.nonNull(clazz.getSuperclass())) {
            this.retrieval(clazz.getSuperclass(), modelName, modelColumns, scopeId, checker, sqlDBModelExtension, record);
        }
    }

    @Override
    public void overrideColumnName(String columnName, String newName) {
        this.columnNameOverrideRule.put(columnName, newName);
        this.models.forEach(this::followColumnNameRules);
        ValueColumnMetadata.INSTANCE.overrideColumnName(columnName, newName);
    }

    private void followColumnNameRules(Model model) {
        this.columnNameOverrideRule.forEach((oldName, newName) -> model.getColumns().forEach(column -> {
            column.getColumnName().overrideName((String)oldName, (String)newName);
            column.getSqlDatabaseExtension().getIndices().forEach(extraQueryIndex -> extraQueryIndex.overrideName((String)oldName, (String)newName));
        }));
    }

    private boolean addExtraColumn4AdditionalEntity(SQLDatabaseModelExtension sqlDBModelExtension, List<ModelColumn> modelColumns, String extraColumn, List<String> additionalTables) {
        for (ModelColumn modelColumn : modelColumns) {
            if (!modelColumn.getColumnName().getName().equals(extraColumn)) continue;
            additionalTables.forEach(tableName -> sqlDBModelExtension.appendAdditionalTable((String)tableName, modelColumn));
            return true;
        }
        return false;
    }

    @Override
    public List<Model> allModels() {
        return this.models;
    }

    private class ShardingKeyChecker {
        private ArrayList<ModelColumn> keys = new ArrayList();

        private ShardingKeyChecker() {
        }

        private void accept(String modelName, ModelColumn modelColumn) throws IllegalStateException {
            int idx = modelColumn.getBanyanDBExtension().getShardingKeyIdx();
            while (idx + 1 > this.keys.size()) {
                this.keys.add(null);
            }
            ModelColumn exist = this.keys.get(idx);
            if (exist != null) {
                throw new IllegalStateException(modelName + "'s Column [" + exist.getColumnName() + "] and column [" + modelColumn.getColumnName() + " are conflicting with sharding key index=" + modelColumn.getBanyanDBExtension().getShardingKeyIdx());
            }
            this.keys.set(idx, modelColumn);
        }

        private void check(String modelName) throws IllegalStateException {
            for (int i = 0; i < this.keys.size(); ++i) {
                ModelColumn modelColumn = this.keys.get(i);
                if (modelColumn != null) continue;
                throw new IllegalStateException("Sharding key index=" + i + " is missing in " + modelName);
            }
        }
    }
}

