/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.RequestType;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScopeDeclaration(id=3, name="Endpoint", catalog="ENDPOINT")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class Endpoint
extends Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Endpoint.class);
    private String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="name", requireDynamicActive=true)
    private String name;
    @ScopeDefaultColumn.DefinedByField(columnName="service_id")
    private String serviceId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_name", requireDynamicActive=true)
    private String serviceName;
    private String serviceInstanceName;
    private int latency;
    private boolean status;
    private int httpResponseStatusCode;
    private String rpcStatusCode;
    private RequestType type;
    private List<String> tags;
    private Map<String, String> originalTags;
    private SideCar sideCar = new SideCar();
    private Layer serviceLayer;

    @Override
    public int scope() {
        return 3;
    }

    @Override
    public String getEntityId() {
        if (StringUtil.isEmpty((String)this.entityId)) {
            this.entityId = IDManager.EndpointID.buildId(this.serviceId, this.name);
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.serviceLayer.isNormal());
    }

    public String getTag(String key) {
        return this.originalTags.get(key);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public int getLatency() {
        return this.latency;
    }

    @Generated
    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Generated
    public boolean isStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(boolean status) {
        this.status = status;
    }

    @Generated
    public int getHttpResponseStatusCode() {
        return this.httpResponseStatusCode;
    }

    @Generated
    public void setHttpResponseStatusCode(int httpResponseStatusCode) {
        this.httpResponseStatusCode = httpResponseStatusCode;
    }

    @Generated
    public String getRpcStatusCode() {
        return this.rpcStatusCode;
    }

    @Generated
    public void setRpcStatusCode(String rpcStatusCode) {
        this.rpcStatusCode = rpcStatusCode;
    }

    @Generated
    public RequestType getType() {
        return this.type;
    }

    @Generated
    public void setType(RequestType type) {
        this.type = type;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setOriginalTags(Map<String, String> originalTags) {
        this.originalTags = originalTags;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public Layer getServiceLayer() {
        return this.serviceLayer;
    }

    @Generated
    public void setServiceLayer(Layer serviceLayer) {
        this.serviceLayer = serviceLayer;
    }
}

