/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type.event;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class Event {
    private static final Gson GSON = new Gson();
    private String uuid;
    private Source source;
    private String name;
    private EventType type;
    private String message;
    private List<KeyValue> parameters;
    private long startTime;
    private long endTime;
    private String layer;

    public void setParameters(List<KeyValue> parameters) {
        this.parameters = parameters;
    }

    public void setParameters(String json) {
        if (StringUtil.isNotEmpty((String)json)) {
            Map map = (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
            this.parameters = map.entrySet().stream().map(e -> new KeyValue((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
    }

    @Generated
    public Event() {
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public EventType getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<KeyValue> getParameters() {
        return this.parameters;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getLayer() {
        return this.layer;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setSource(Source source) {
        this.source = source;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(EventType type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLayer(String layer) {
        this.layer = layer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EventType this$type = this.getType();
        EventType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<KeyValue> this$parameters = this.getParameters();
        List<KeyValue> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$layer = this.getLayer();
        String other$layer = other.getLayer();
        return !(this$layer == null ? other$layer != null : !this$layer.equals(other$layer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<KeyValue> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : $layer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Event(uuid=" + this.getUuid() + ", source=" + this.getSource() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", message=" + this.getMessage() + ", parameters=" + this.getParameters() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", layer=" + this.getLayer() + ")";
    }
}

