/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.LogEntity;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Ref;
import org.apache.skywalking.oap.server.core.query.type.RefType;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class TraceQueryService
implements Service {
    private final ModuleManager moduleManager;
    private ITraceQueryDAO traceQueryDAO;
    private IComponentLibraryCatalogService componentLibraryCatalogService;

    public TraceQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ITraceQueryDAO getTraceQueryDAO() {
        if (this.traceQueryDAO == null) {
            this.traceQueryDAO = (ITraceQueryDAO)this.moduleManager.find("storage").provider().getService(ITraceQueryDAO.class);
        }
        return this.traceQueryDAO;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    public TraceBrief queryBasicTraces(String serviceId, String serviceInstanceId, String endpointId, String traceId, int minTraceDuration, int maxTraceDuration, TraceState traceState, QueryOrder queryOrder, Pagination paging, long startTB, long endTB, List<Tag> tags) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        return this.getTraceQueryDAO().queryBasicTraces(startTB, endTB, minTraceDuration, maxTraceDuration, serviceId, serviceInstanceId, endpointId, traceId, page.getLimit(), page.getFrom(), traceState, queryOrder, tags);
    }

    public Trace queryTrace(String traceId) throws IOException {
        List<Span> rootSpans;
        Trace trace = new Trace();
        List<SegmentRecord> segmentRecords = this.getTraceQueryDAO().queryByTraceId(traceId);
        if (segmentRecords.isEmpty()) {
            trace.getSpans().addAll(this.getTraceQueryDAO().doFlexibleTraceQuery(traceId));
        } else {
            for (SegmentRecord segment : segmentRecords) {
                if (!Objects.nonNull(segment)) continue;
                SegmentObject segmentObject = SegmentObject.parseFrom((byte[])segment.getDataBinary());
                trace.getSpans().addAll(this.buildSpanList(segmentObject));
            }
        }
        LinkedList sortedSpans = new LinkedList();
        if (CollectionUtils.isNotEmpty(trace.getSpans()) && CollectionUtils.isNotEmpty(rootSpans = this.findRoot(trace.getSpans()))) {
            rootSpans.forEach(span -> {
                ArrayList<Span> childrenSpan = new ArrayList<Span>();
                childrenSpan.add((Span)span);
                this.findChildren(trace.getSpans(), (Span)span, (List<Span>)childrenSpan);
                sortedSpans.addAll(childrenSpan);
            });
        }
        trace.getSpans().clear();
        trace.getSpans().addAll(sortedSpans);
        return trace;
    }

    private List<Span> buildSpanList(SegmentObject segmentObject) {
        ArrayList<Span> spans = new ArrayList<Span>();
        segmentObject.getSpansList().forEach(spanObject -> {
            Span span = new Span();
            span.setTraceId(segmentObject.getTraceId());
            span.setSegmentId(segmentObject.getTraceSegmentId());
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            String segmentSpanId = segmentObject.getTraceSegmentId() + "S" + spanObject.getSpanId();
            span.setSegmentSpanId(segmentSpanId);
            String segmentParentSpanId = segmentObject.getTraceSegmentId() + "S" + spanObject.getParentSpanId();
            span.setSegmentParentSpanId(segmentParentSpanId);
            span.setPeer(spanObject.getPeer());
            span.setEndpointName(spanObject.getOperationName());
            span.setServiceCode(segmentObject.getService());
            span.setServiceInstanceName(segmentObject.getServiceInstance());
            span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            spanObject.getRefsList().forEach(reference -> {
                Ref ref = new Ref();
                ref.setTraceId(reference.getTraceId());
                ref.setParentSegmentId(reference.getParentTraceSegmentId());
                switch (reference.getRefType()) {
                    case CrossThread: {
                        ref.setType(RefType.CROSS_THREAD);
                        break;
                    }
                    case CrossProcess: {
                        ref.setType(RefType.CROSS_PROCESS);
                    }
                }
                ref.setParentSpanId(reference.getParentSpanId());
                span.setSegmentParentSpanId(ref.getParentSegmentId() + "S" + ref.getParentSpanId());
                span.getRefs().add(ref);
            });
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            spans.add(span);
        });
        return spans;
    }

    private List<Span> findRoot(List<Span> spans) {
        ArrayList<Span> rootSpans = new ArrayList<Span>();
        spans.forEach(span -> {
            String segmentParentSpanId = span.getSegmentParentSpanId();
            boolean hasParent = false;
            for (Span subSpan : spans) {
                if (!segmentParentSpanId.equals(subSpan.getSegmentSpanId())) continue;
                hasParent = true;
                break;
            }
            if (!hasParent) {
                span.setRoot(true);
                rootSpans.add((Span)span);
            }
        });
        rootSpans.sort(Comparator.comparing(Span::getStartTime));
        return rootSpans;
    }

    private void findChildren(List<Span> spans, Span parentSpan, List<Span> childrenSpan) {
        spans.forEach(span -> {
            if (span.getSegmentParentSpanId().equals(parentSpan.getSegmentSpanId())) {
                childrenSpan.add((Span)span);
                this.findChildren(spans, (Span)span, childrenSpan);
            }
        });
    }
}

