/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.Set;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class TagAutoCompleteQueryService
implements Service {
    private final ModuleManager moduleManager;
    private final CoreModuleConfig config;
    private ITagAutoCompleteQueryDAO tagAutoCompleteQueryDAO;

    public TagAutoCompleteQueryService(ModuleManager moduleManager, CoreModuleConfig config) {
        this.moduleManager = moduleManager;
        this.config = config;
    }

    private ITagAutoCompleteQueryDAO getTagAutoCompleteQueryDAO() {
        if (this.tagAutoCompleteQueryDAO == null) {
            this.tagAutoCompleteQueryDAO = (ITagAutoCompleteQueryDAO)this.moduleManager.find("storage").provider().getService(ITagAutoCompleteQueryDAO.class);
        }
        return this.tagAutoCompleteQueryDAO;
    }

    public Set<String> queryTagAutocompleteKeys(TagType tagType, long startSecondTB, long endSecondTB) throws IOException {
        return this.getTagAutoCompleteQueryDAO().queryTagAutocompleteKeys(tagType, this.config.getAutocompleteTagKeysQueryMaxSize(), startSecondTB, endSecondTB);
    }

    public Set<String> queryTagAutocompleteValues(TagType tagType, String tagKey, long startSecondTB, long endSecondTB) throws IOException {
        return this.getTagAutoCompleteQueryDAO().queryTagAutocompleteValues(tagType, tagKey, this.config.getAutocompleteTagValuesQueryMaxSize(), startSecondTB, endSecondTB);
    }
}

