/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceNode;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceTopologyBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceInstanceTopologyBuilder.class);
    private final IComponentLibraryCatalogService componentLibraryCatalogService;

    public ServiceInstanceTopologyBuilder(ModuleManager moduleManager) {
        this.componentLibraryCatalogService = (IComponentLibraryCatalogService)moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
    }

    ServiceInstanceTopology build(List<Call.CallDetail> serviceInstanceRelationClientCalls, List<Call.CallDetail> serviceInstanceRelationServerCalls) {
        ServiceInstanceNode node;
        IDManager.ServiceID.ServiceIDDefinition destService;
        IDManager.ServiceInstanceID.InstanceIDDefinition destServiceInstance;
        IDManager.ServiceID.ServiceIDDefinition sourceService;
        IDManager.ServiceInstanceID.InstanceIDDefinition sourceServiceInstance;
        HashMap<String, ServiceInstanceNode> nodes = new HashMap<String, ServiceInstanceNode>();
        LinkedList<Call> calls = new LinkedList<Call>();
        HashMap<String, Call> callMap = new HashMap<String, Call>();
        for (Call.CallDetail clientCall : serviceInstanceRelationClientCalls) {
            sourceServiceInstance = IDManager.ServiceInstanceID.analysisId(clientCall.getSource());
            sourceService = IDManager.ServiceID.analysisId(sourceServiceInstance.getServiceId());
            destServiceInstance = IDManager.ServiceInstanceID.analysisId(clientCall.getTarget());
            destService = IDManager.ServiceID.analysisId(destServiceInstance.getServiceId());
            if (!nodes.containsKey(clientCall.getSource())) {
                nodes.put(clientCall.getSource(), this.buildNode(sourceService, sourceServiceInstance));
            }
            if (!nodes.containsKey(clientCall.getTarget())) {
                node = this.buildNode(destService, destServiceInstance);
                nodes.put(clientCall.getTarget(), node);
                if (!node.isReal() && StringUtil.isEmpty((String)node.getType())) {
                    node.setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(clientCall.getComponentId()));
                }
            }
            if (callMap.containsKey(clientCall.getId())) continue;
            Call call = new Call();
            callMap.put(clientCall.getId(), call);
            call.setSource(clientCall.getSource());
            call.setTarget(clientCall.getTarget());
            call.setId(clientCall.getId());
            call.addDetectPoint(DetectPoint.CLIENT);
            call.addSourceComponent(this.componentLibraryCatalogService.getComponentName(clientCall.getComponentId()));
            calls.add(call);
        }
        for (Call.CallDetail serverCall : serviceInstanceRelationServerCalls) {
            Call call;
            sourceServiceInstance = IDManager.ServiceInstanceID.analysisId(serverCall.getSource());
            sourceService = IDManager.ServiceID.analysisId(sourceServiceInstance.getServiceId());
            destServiceInstance = IDManager.ServiceInstanceID.analysisId(serverCall.getTarget());
            destService = IDManager.ServiceID.analysisId(destServiceInstance.getServiceId());
            if (!nodes.containsKey(serverCall.getSource())) {
                nodes.put(serverCall.getSource(), this.buildNode(sourceService, sourceServiceInstance));
            }
            if (!nodes.containsKey(serverCall.getTarget())) {
                node = this.buildNode(destService, destServiceInstance);
                nodes.put(serverCall.getTarget(), node);
            }
            ServiceInstanceNode serverSideNode = (ServiceInstanceNode)nodes.get(serverCall.getTarget());
            serverSideNode.setType(this.componentLibraryCatalogService.getServerNameBasedOnComponent(serverCall.getComponentId()));
            if (!callMap.containsKey(serverCall.getId())) {
                call = new Call();
                callMap.put(serverCall.getId(), call);
                call.setSource(serverCall.getSource());
                call.setTarget(serverCall.getTarget());
                call.setId(serverCall.getId());
                call.addDetectPoint(DetectPoint.SERVER);
                call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
                calls.add(call);
                continue;
            }
            call = (Call)callMap.get(serverCall.getId());
            call.addDetectPoint(DetectPoint.SERVER);
            call.addTargetComponent(this.componentLibraryCatalogService.getComponentName(serverCall.getComponentId()));
        }
        ServiceInstanceTopology topology = new ServiceInstanceTopology();
        topology.getCalls().addAll(calls);
        topology.getNodes().addAll(nodes.values());
        return topology;
    }

    private ServiceInstanceNode buildNode(IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition, IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition) {
        ServiceInstanceNode instanceNode = new ServiceInstanceNode();
        instanceNode.setId(IDManager.ServiceInstanceID.buildId(instanceIDDefinition.getServiceId(), instanceIDDefinition.getName()));
        instanceNode.setName(instanceIDDefinition.getName());
        instanceNode.setServiceId(instanceIDDefinition.getServiceId());
        instanceNode.setServiceName(serviceIDDefinition.getName());
        instanceNode.setReal(serviceIDDefinition.isReal());
        return instanceNode;
    }
}

