/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.query.MetricDefinition;
import org.apache.skywalking.oap.server.core.query.enumeration.MetricsType;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class MetricsMetadataQueryService
implements Service {
    public MetricsType typeOfMetrics(String metricsName) {
        Optional<ValueColumnMetadata.ValueColumn> valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricsName);
        if (valueColumn.isPresent()) {
            switch (valueColumn.get().getDataType()) {
                case COMMON_VALUE: {
                    return MetricsType.REGULAR_VALUE;
                }
                case LABELED_VALUE: {
                    return MetricsType.LABELED_VALUE;
                }
                case HISTOGRAM: {
                    return MetricsType.HEATMAP;
                }
                case SAMPLED_RECORD: {
                    return MetricsType.SAMPLED_RECORD;
                }
            }
            return MetricsType.UNKNOWN;
        }
        return MetricsType.UNKNOWN;
    }

    public List<MetricDefinition> listMetrics(String regex) {
        return ValueColumnMetadata.INSTANCE.getAllMetadata().entrySet().stream().filter(metadata -> StringUtil.isNotEmpty((String)regex) ? ((String)metadata.getKey()).matches(regex) : true).map(metadata -> new MetricDefinition((String)metadata.getKey(), this.typeOfMetrics((String)metadata.getKey()), DefaultScopeDefine.catalogOf(((ValueColumnMetadata.ValueColumn)metadata.getValue()).getScopeId()))).collect(Collectors.toList());
    }
}

