/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.EndpointInfo;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class MetadataQueryService
implements org.apache.skywalking.oap.server.library.module.Service {
    private final ModuleManager moduleManager;
    private IMetadataQueryDAO metadataQueryDAO;

    public MetadataQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    public Set<String> listLayers() throws IOException {
        return Arrays.stream(Layer.values()).filter(layer -> layer.value() > 0).map(Enum::name).collect(Collectors.toSet());
    }

    public List<Service> listServices(String layer, String group) throws IOException {
        return this.combineServices(this.getMetadataQueryDAO().listServices(layer, group));
    }

    public Service getService(String serviceId) throws IOException {
        List<Service> services = this.combineServices(this.getMetadataQueryDAO().getServices(serviceId));
        return services.size() > 0 ? services.get(0) : null;
    }

    public ServiceInstance getInstance(String instanceId) throws IOException {
        return this.getMetadataQueryDAO().getInstance(instanceId);
    }

    public List<ServiceInstance> listInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        return this.getMetadataQueryDAO().listInstances(startTimestamp, endTimestamp, serviceId).stream().distinct().collect(Collectors.toList());
    }

    public List<Endpoint> findEndpoint(String keyword, String serviceId, int limit) throws IOException {
        return this.getMetadataQueryDAO().findEndpoint(keyword, serviceId, limit).stream().distinct().collect(Collectors.toList());
    }

    public EndpointInfo getEndpointInfo(String endpointId) throws IOException {
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
        EndpointInfo endpointInfo = new EndpointInfo();
        endpointInfo.setId(endpointId);
        endpointInfo.setName(endpointIDDefinition.getEndpointName());
        endpointInfo.setServiceId(endpointIDDefinition.getServiceId());
        endpointInfo.setServiceName(serviceIDDefinition.getName());
        return endpointInfo;
    }

    public List<Process> listProcesses(Duration duration, String instanceId) throws IOException {
        if (duration.getEndTimeBucket() < duration.getStartTimeBucket()) {
            return Collections.emptyList();
        }
        return this.getMetadataQueryDAO().listProcesses(instanceId, duration.getStartTimeBucket(), duration.getEndTimeBucket(), true);
    }

    public Process getProcess(String processId) throws IOException {
        if (StringUtils.isEmpty((CharSequence)processId)) {
            return null;
        }
        return this.getMetadataQueryDAO().getProcess(processId);
    }

    public Long estimateProcessScale(String serviceId, List<String> labels) throws IOException {
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            return 0L;
        }
        long endTimestamp = System.currentTimeMillis();
        long startTimestamp = endTimestamp - TimeUnit.MINUTES.toMillis(10L);
        List<Process> processes = this.getMetadataQueryDAO().listProcesses(serviceId, ProfilingSupportStatus.SUPPORT_EBPF_PROFILING, TimeBucket.getTimeBucket(startTimestamp, DownSampling.Minute), TimeBucket.getTimeBucket(endTimestamp, DownSampling.Minute));
        return CollectionUtils.isEmpty(processes) ? 0L : processes.stream().filter(p -> p.getLabels().containsAll(labels)).count();
    }

    private List<Service> combineServices(List<Service> services) {
        return new ArrayList<Service>(services.stream().peek(service -> {
            if (service.getGroup() == null) {
                service.setGroup("");
            }
        }).collect(Collectors.toMap(Service::getName, service -> service, (s1, s2) -> {
            s1.getLayers().addAll(s2.getLayers());
            return s1;
        })).values());
    }
}

