/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace.analyze;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.apache.skywalking.oap.server.core.profiling.trace.analyze.ProfileStack;
import org.apache.skywalking.oap.server.core.query.type.ProfileStackElement;
import org.apache.skywalking.oap.server.core.query.type.ProfileStackTree;

public class ProfileStackNode {
    private String codeSignature;
    private List<ProfileStack> detectedStacks;
    private List<ProfileStackNode> children;
    private int duration;

    public static ProfileStackNode newNode() {
        ProfileStackNode emptyNode = new ProfileStackNode();
        emptyNode.detectedStacks = new LinkedList<ProfileStack>();
        emptyNode.children = new ArrayList<ProfileStackNode>();
        return emptyNode;
    }

    public void accumulateFrom(ProfileStack stack) {
        List<String> stackList = stack.getStack();
        if (this.codeSignature == null) {
            this.codeSignature = stackList.get(0);
        }
        this.detectedBy(stack);
        ProfileStackNode parent = this;
        for (int depth = 1; depth < stackList.size(); ++depth) {
            String elementCodeSignature = stackList.get(depth);
            ProfileStackNode childElement = null;
            for (ProfileStackNode child : parent.children) {
                if (!Objects.equal((Object)child.codeSignature, (Object)elementCodeSignature)) continue;
                childElement = child;
                break;
            }
            if (childElement != null) {
                super.detectedBy(stack);
                parent = childElement;
                continue;
            }
            ProfileStackNode childNode = ProfileStackNode.newNode();
            childNode.codeSignature = elementCodeSignature;
            childNode.detectedBy(stack);
            parent.children.add(childNode);
            parent = childNode;
        }
    }

    public ProfileStackNode combine(ProfileStackNode node) {
        this.combineDetectedStacks(node);
        LinkedList<Pair<ProfileStackNode, ProfileStackNode>> stack = new LinkedList<Pair<ProfileStackNode, ProfileStackNode>>();
        stack.add(new Pair<ProfileStackNode, ProfileStackNode>(this, node));
        while (!stack.isEmpty()) {
            Pair needCombineNode = (Pair)stack.pop();
            this.combineChildrenNodes((ProfileStackNode)needCombineNode.key, (ProfileStackNode)needCombineNode.value, stack::add);
        }
        return this;
    }

    private void combineChildrenNodes(ProfileStackNode targetNode, ProfileStackNode beingMergedNode, Consumer<Pair<ProfileStackNode, ProfileStackNode>> continueChildrenMerging) {
        if (beingMergedNode.children.isEmpty()) {
            return;
        }
        block0: for (ProfileStackNode childrenNode : targetNode.children) {
            ListIterator<ProfileStackNode> it = beingMergedNode.children.listIterator();
            while (it.hasNext()) {
                ProfileStackNode node = it.next();
                if (node == null || !node.matches(childrenNode)) continue;
                childrenNode.combineDetectedStacks(node);
                continueChildrenMerging.accept(new Pair<ProfileStackNode, ProfileStackNode>(childrenNode, node));
                it.set(null);
                continue block0;
            }
        }
        for (ProfileStackNode node : beingMergedNode.children) {
            if (node == null) continue;
            targetNode.children.add(node);
        }
    }

    public ProfileStackTree buildAnalyzeResult() {
        LinkedList<Pair<ProfileStackElement, ProfileStackNode>> nodeMapping = new LinkedList<Pair<ProfileStackElement, ProfileStackNode>>();
        int idGenerator = 1;
        ProfileStackElement root = this.buildElement(idGenerator++);
        nodeMapping.add(new Pair<ProfileStackElement, ProfileStackNode>(root, this));
        LinkedList<Pair<ProfileStackElement, ProfileStackNode>> stack = new LinkedList<Pair<ProfileStackElement, ProfileStackNode>>();
        stack.add(new Pair<ProfileStackElement, ProfileStackNode>(root, this));
        while (!stack.isEmpty()) {
            Pair mergingPair = (Pair)stack.pop();
            ProfileStackElement respElement = (ProfileStackElement)mergingPair.key;
            for (ProfileStackNode children : ((ProfileStackNode)((Pair)mergingPair).value).children) {
                ProfileStackElement element = children.buildElement(idGenerator++);
                element.setParentId(respElement.getId());
                Pair<ProfileStackElement, ProfileStackNode> pair = new Pair<ProfileStackElement, ProfileStackNode>(element, children);
                stack.add(pair);
                nodeMapping.add(pair);
            }
        }
        nodeMapping.parallelStream().forEach(t -> ((ProfileStackNode)((Pair)t).value).calculateDuration((ProfileStackElement)((Pair)t).key));
        nodeMapping.parallelStream().forEach(t -> ((ProfileStackNode)((Pair)t).value).calculateDurationExcludeChild((ProfileStackElement)((Pair)t).key));
        ProfileStackTree tree = new ProfileStackTree();
        nodeMapping.forEach(n -> tree.getElements().add((ProfileStackElement)((Pair)n).key));
        return tree;
    }

    private void detectedBy(ProfileStack stack) {
        this.detectedStacks.add(stack);
    }

    private void combineDetectedStacks(ProfileStackNode node) {
        this.detectedStacks.addAll(node.detectedStacks);
    }

    private ProfileStackElement buildElement(int id) {
        ProfileStackElement element = new ProfileStackElement();
        element.setId(id);
        element.setCodeSignature(this.codeSignature);
        element.setCount(this.detectedStacks.size());
        return element;
    }

    private void calculateDuration(ProfileStackElement element) {
        if (this.detectedStacks.size() <= 1) {
            element.setDuration(0);
            return;
        }
        Collections.sort(this.detectedStacks);
        ProfileStack currentTimeWindowStartStack = this.detectedStacks.get(0);
        ProfileStack currentTimeWindowEndTack = this.detectedStacks.get(0);
        long duration = 0L;
        ListIterator<ProfileStack> it = this.detectedStacks.listIterator(1);
        while (it.hasNext()) {
            ProfileStack currentStack = it.next();
            if (currentTimeWindowEndTack.getSequence() + 1 != currentStack.getSequence()) {
                duration += currentTimeWindowEndTack.getDumpTime() - currentTimeWindowStartStack.getDumpTime();
                currentTimeWindowStartStack = currentStack;
            }
            currentTimeWindowEndTack = currentStack;
        }
        this.duration = Math.toIntExact(duration += currentTimeWindowEndTack.getDumpTime() - currentTimeWindowStartStack.getDumpTime());
        element.setDuration(this.duration);
    }

    private void calculateDurationExcludeChild(ProfileStackElement element) {
        element.setDurationChildExcluded(element.getDuration() - this.children.stream().mapToInt(t -> t.duration).sum());
    }

    private boolean matches(ProfileStackNode node) {
        return Objects.equal((Object)this.codeSignature, (Object)node.codeSignature);
    }

    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

