/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.profiling.trace.analyze.ProfileAnalyzeCollector;
import org.apache.skywalking.oap.server.core.profiling.trace.analyze.ProfileStack;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.ProfileStackTree;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileAnalyzer.class);
    private static final ProfileAnalyzeCollector ANALYZE_COLLECTOR = new ProfileAnalyzeCollector();
    private final int threadSnapshotAnalyzeBatchSize;
    private final int analyzeSnapshotMaxSize;
    private final ModuleManager moduleManager;
    protected IProfileThreadSnapshotQueryDAO profileThreadSnapshotQueryDAO;

    public ProfileAnalyzer(ModuleManager moduleManager, int snapshotAnalyzeBatchSize, int analyzeSnapshotMaxSize) {
        this.moduleManager = moduleManager;
        this.threadSnapshotAnalyzeBatchSize = snapshotAnalyzeBatchSize;
        this.analyzeSnapshotMaxSize = analyzeSnapshotMaxSize;
    }

    public ProfileAnalyzation analyze(String segmentId, List<ProfileAnalyzeTimeRange> timeRanges) throws IOException {
        List<ProfileStack> stacks;
        List<ProfileStackTree> trees;
        ProfileAnalyzation analyzation = new ProfileAnalyzation();
        SequenceSearch sequenceSearch = this.getAllSequenceRange(segmentId, timeRanges);
        if (sequenceSearch == null) {
            analyzation.setTip("Data not found");
            return analyzation;
        }
        if (sequenceSearch.getTotalSequenceCount() > this.analyzeSnapshotMaxSize) {
            analyzation.setTip("Out of snapshot analyze limit, " + sequenceSearch.getTotalSequenceCount() + " snapshots found, but analysis first " + this.analyzeSnapshotMaxSize + " snapshots only.");
        }
        if ((trees = this.analyze(stacks = sequenceSearch.getRanges().parallelStream().map(r -> {
            try {
                return this.getProfileThreadSnapshotQueryDAO().queryRecords(segmentId, r.getMinSequence(), r.getMaxSequence());
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }).flatMap(Collection::stream).map(ProfileStack::deserialize).distinct().collect(Collectors.toList()))) != null) {
            analyzation.getTrees().addAll(trees);
        }
        return analyzation;
    }

    protected SequenceSearch getAllSequenceRange(String segmentId, List<ProfileAnalyzeTimeRange> timeRanges) {
        List searches = timeRanges.parallelStream().map(r -> {
            try {
                return this.getAllSequenceRange(segmentId, r.getStart(), r.getEnd());
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return searches.stream().reduce(new SequenceSearch(0), SequenceSearch::combine);
    }

    protected SequenceSearch getAllSequenceRange(String segmentId, long start, long end) throws IOException {
        int batchMax;
        int minSequence = this.getProfileThreadSnapshotQueryDAO().queryMinSequence(segmentId, start, end);
        int maxSequence = this.getProfileThreadSnapshotQueryDAO().queryMaxSequence(segmentId, start, end) + 1;
        if (maxSequence <= 0) {
            return null;
        }
        SequenceSearch sequenceSearch = new SequenceSearch(maxSequence - minSequence);
        maxSequence = Math.min(maxSequence, minSequence + this.analyzeSnapshotMaxSize);
        do {
            batchMax = Math.min(minSequence + this.threadSnapshotAnalyzeBatchSize, maxSequence);
            sequenceSearch.getRanges().add(new SequenceRange(minSequence, batchMax));
        } while ((minSequence = batchMax) < maxSequence);
        return sequenceSearch;
    }

    protected List<ProfileStackTree> analyze(List<ProfileStack> stacks) {
        if (CollectionUtils.isEmpty(stacks)) {
            return null;
        }
        Map<String, ProfileStackTree> stackTrees = stacks.parallelStream().filter(s -> CollectionUtils.isNotEmpty(s.getStack())).collect(Collectors.groupingBy(s -> s.getStack().get(0), ANALYZE_COLLECTOR));
        return new ArrayList<ProfileStackTree>(stackTrees.values());
    }

    protected IProfileThreadSnapshotQueryDAO getProfileThreadSnapshotQueryDAO() {
        if (this.profileThreadSnapshotQueryDAO == null) {
            this.profileThreadSnapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        }
        return this.profileThreadSnapshotQueryDAO;
    }

    private static class SequenceRange {
        private int minSequence;
        private int maxSequence;

        public SequenceRange(int minSequence, int maxSequence) {
            this.minSequence = minSequence;
            this.maxSequence = maxSequence;
        }

        public int getMinSequence() {
            return this.minSequence;
        }

        public int getMaxSequence() {
            return this.maxSequence;
        }
    }

    private static class SequenceSearch {
        private LinkedList<SequenceRange> ranges = new LinkedList();
        private int totalSequenceCount;

        public SequenceSearch(int totalSequenceCount) {
            this.totalSequenceCount = totalSequenceCount;
        }

        public LinkedList<SequenceRange> getRanges() {
            return this.ranges;
        }

        public int getTotalSequenceCount() {
            return this.totalSequenceCount;
        }

        public SequenceSearch combine(SequenceSearch search) {
            this.ranges.addAll(search.ranges);
            this.totalSequenceCount += search.totalSequenceCount;
            return this;
        }
    }
}

