/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.profiling.trace.analyze.ProfileAnalyzer;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.LogEntity;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfiledSegment;
import org.apache.skywalking.oap.server.core.query.type.ProfiledSpan;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class ProfileTaskQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IProfileTaskQueryDAO profileTaskQueryDAO;
    private IProfileTaskLogQueryDAO profileTaskLogQueryDAO;
    private IProfileThreadSnapshotQueryDAO profileThreadSnapshotQueryDAO;
    private NetworkAddressAliasCache networkAddressAliasCache;
    private IComponentLibraryCatalogService componentLibraryCatalogService;
    private final ProfileAnalyzer profileAnalyzer;

    public ProfileTaskQueryService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.profileAnalyzer = new ProfileAnalyzer(moduleManager, moduleConfig.getMaxPageSizeOfQueryProfileSnapshot(), moduleConfig.getMaxSizeOfAnalyzeProfileSnapshot());
    }

    private IProfileTaskQueryDAO getProfileTaskDAO() {
        if (Objects.isNull(this.profileTaskQueryDAO)) {
            this.profileTaskQueryDAO = (IProfileTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskQueryDAO.class);
        }
        return this.profileTaskQueryDAO;
    }

    private IProfileTaskLogQueryDAO getProfileTaskLogQueryDAO() {
        if (Objects.isNull(this.profileTaskLogQueryDAO)) {
            this.profileTaskLogQueryDAO = (IProfileTaskLogQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskLogQueryDAO.class);
        }
        return this.profileTaskLogQueryDAO;
    }

    private IProfileThreadSnapshotQueryDAO getProfileThreadSnapshotQueryDAO() {
        if (Objects.isNull(this.profileThreadSnapshotQueryDAO)) {
            this.profileThreadSnapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        }
        return this.profileThreadSnapshotQueryDAO;
    }

    private NetworkAddressAliasCache getNetworkAddressAliasCache() {
        if (this.networkAddressAliasCache == null) {
            this.networkAddressAliasCache = (NetworkAddressAliasCache)this.moduleManager.find("core").provider().getService(NetworkAddressAliasCache.class);
        }
        return this.networkAddressAliasCache;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    public List<ProfileTask> getTaskList(String serviceId, String endpointName) throws IOException {
        List<ProfileTask> tasks = this.getProfileTaskDAO().getTaskList(serviceId, endpointName, null, null, null);
        List<ProfileTaskLog> taskLogList = this.getProfileTaskLogQueryDAO().getTaskLogList();
        if (taskLogList == null) {
            taskLogList = Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (ProfileTask task : tasks) {
                IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(task.getServiceId());
                task.setServiceName(serviceIDDefinition.getName());
                task.setLogs(this.findMatchedLogs(task.getId(), taskLogList));
            }
        }
        return tasks;
    }

    public List<ProfileTaskLog> getProfileTaskLogs(String taskID) throws IOException {
        List<ProfileTaskLog> taskLogList = this.getProfileTaskLogQueryDAO().getTaskLogList();
        if (CollectionUtils.isEmpty(taskLogList)) {
            return Collections.emptyList();
        }
        return this.findMatchedLogs(taskID, taskLogList);
    }

    public List<BasicTrace> getTaskTraces(String taskId) throws IOException {
        return this.getProfileThreadSnapshotQueryDAO().queryProfiledSegments(taskId);
    }

    public ProfileAnalyzation getProfileAnalyze(String segmentId, List<ProfileAnalyzeTimeRange> timeRanges) throws IOException {
        return this.profileAnalyzer.analyze(segmentId, timeRanges);
    }

    public ProfiledSegment getProfiledSegment(String segmentId) throws IOException {
        SegmentRecord segmentRecord = this.getProfileThreadSnapshotQueryDAO().getProfiledSegment(segmentId);
        if (segmentRecord == null) {
            return null;
        }
        ProfiledSegment profiledSegment = new ProfiledSegment();
        SegmentObject segmentObject = SegmentObject.parseFrom((byte[])segmentRecord.getDataBinary());
        profiledSegment.getSpans().addAll(this.buildProfiledSpanList(segmentObject));
        return profiledSegment;
    }

    private List<ProfiledSpan> buildProfiledSpanList(SegmentObject segmentObject) {
        ArrayList<ProfiledSpan> spans = new ArrayList<ProfiledSpan>();
        segmentObject.getSpansList().forEach(spanObject -> {
            ProfiledSpan span = new ProfiledSpan();
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            span.setEndpointName(spanObject.getOperationName());
            span.setPeer(spanObject.getPeer());
            span.setEndpointName(spanObject.getOperationName());
            span.setServiceCode(segmentObject.getService());
            span.setServiceInstanceName(segmentObject.getServiceInstance());
            span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            spans.add(span);
        });
        return spans;
    }

    private List<ProfileTaskLog> findMatchedLogs(String taskID, List<ProfileTaskLog> allLogs) {
        return allLogs.stream().filter(l -> com.google.common.base.Objects.equal((Object)l.getTaskId(), (Object)taskID)).map(this::extendTaskLog).collect(Collectors.toList());
    }

    private ProfileTaskLog extendTaskLog(ProfileTaskLog log) {
        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(log.getInstanceId());
        log.setInstanceName(instanceIDDefinition.getName());
        return log;
    }
}

