/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=27, name="ProfileTaskLog")
@Stream(name="profile_task_log", scopeId=27, builder=Builder.class, processor=RecordStreamProcessor.class)
public class ProfileTaskLogRecord
extends Record {
    public static final String INDEX_NAME = "profile_task_log";
    public static final String TASK_ID = "task_id";
    public static final String INSTANCE_ID = "instance_id";
    public static final String OPERATION_TYPE = "operation_type";
    public static final String OPERATION_TIME = "operation_time";
    @Column(columnName="task_id")
    private String taskId;
    @Column(columnName="instance_id")
    @BanyanDB.ShardingKey(index=0)
    private String instanceId;
    @Column(columnName="operation_type", storageOnly=true)
    private int operationType;
    @Column(columnName="operation_time")
    private long operationTime;

    @Override
    public String id() {
        return this.getTaskId() + "_" + this.getInstanceId() + "_" + this.getOperationType() + "_" + this.getOperationTime();
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public int getOperationType() {
        return this.operationType;
    }

    @Generated
    public long getOperationTime() {
        return this.operationTime;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    @Generated
    public void setOperationTime(long operationTime) {
        this.operationTime = operationTime;
    }

    public static class Builder
    implements StorageBuilder<ProfileTaskLogRecord> {
        @Override
        public ProfileTaskLogRecord storage2Entity(Convert2Entity converter) {
            ProfileTaskLogRecord log = new ProfileTaskLogRecord();
            log.setTaskId((String)converter.get(ProfileTaskLogRecord.TASK_ID));
            log.setInstanceId((String)converter.get(ProfileTaskLogRecord.INSTANCE_ID));
            log.setOperationType(((Number)converter.get(ProfileTaskLogRecord.OPERATION_TYPE)).intValue());
            log.setOperationTime(((Number)converter.get(ProfileTaskLogRecord.OPERATION_TIME)).longValue());
            log.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return log;
        }

        @Override
        public void entity2Storage(ProfileTaskLogRecord storageData, Convert2Storage converter) {
            converter.accept(ProfileTaskLogRecord.TASK_ID, storageData.getTaskId());
            converter.accept(ProfileTaskLogRecord.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(ProfileTaskLogRecord.OPERATION_TYPE, storageData.getOperationType());
            converter.accept(ProfileTaskLogRecord.OPERATION_TIME, storageData.getOperationTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

