/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum EBPFProfilingTriggerType {
    UNKNOWN(0),
    FIXED_TIME(1);

    private final int value;
    private static final Map<Integer, EBPFProfilingTriggerType> DICTIONARY;

    private EBPFProfilingTriggerType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static EBPFProfilingTriggerType valueOf(int value) {
        EBPFProfilingTriggerType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown EBPFProfilingTriggerType value");
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, EBPFProfilingTriggerType>();
        Arrays.stream(EBPFProfilingTriggerType.values()).collect(Collectors.toMap(EBPFProfilingTriggerType::value, type -> type)).forEach(DICTIONARY::put);
    }
}

