/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=46, name="EBPFProfilingTask")
@Stream(name="ebpf_profiling_task", scopeId=46, builder=Builder.class, processor=NoneStreamProcessor.class)
public class EBPFProfilingTaskRecord
extends NoneStream {
    public static final String INDEX_NAME = "ebpf_profiling_task";
    public static final String LOGICAL_ID = "logical_id";
    public static final String SERVICE_ID = "service_id";
    public static final String PROCESS_LABELS_JSON = "process_labels_json";
    public static final String INSTANCE_ID = "instance_id";
    public static final String START_TIME = "start_time";
    public static final String TRIGGER_TYPE = "trigger_type";
    public static final String FIXED_TRIGGER_DURATION = "fixed_trigger_duration";
    public static final String TARGET_TYPE = "target_type";
    public static final String CREATE_TIME = "create_time";
    public static final String LAST_UPDATE_TIME = "last_update_time";
    public static final int PROCESS_LABELS_JSON_MAX_LENGTH = 1000;
    @Column(columnName="logical_id")
    private String logicalId;
    @Column(columnName="service_id")
    @BanyanDB.ShardingKey(index=0)
    private String serviceId;
    @Column(columnName="process_labels_json", length=1000)
    private String processLabelsJson;
    @Column(columnName="instance_id")
    private String instanceId;
    @Column(columnName="start_time")
    private long startTime;
    @Column(columnName="trigger_type")
    private int triggerType = EBPFProfilingTriggerType.UNKNOWN.value();
    @Column(columnName="fixed_trigger_duration")
    private long fixedTriggerDuration;
    @Column(columnName="target_type")
    private int targetType = EBPFProfilingTargetType.UNKNOWN.value();
    @Column(columnName="create_time")
    private long createTime;
    @Column(columnName="last_update_time")
    private long lastUpdateTime;

    @Override
    public String id() {
        return Hashing.sha256().newHasher().putString((CharSequence)this.logicalId, Charsets.UTF_8).putLong(this.createTime).hash().toString();
    }

    public void generateLogicalId() {
        this.logicalId = Hashing.sha256().newHasher().putString((CharSequence)this.serviceId, Charsets.UTF_8).putString((CharSequence)this.processLabelsJson, Charsets.UTF_8).putLong(this.startTime).hash().toString();
    }

    @Generated
    public EBPFProfilingTaskRecord() {
    }

    @Generated
    public String getLogicalId() {
        return this.logicalId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getProcessLabelsJson() {
        return this.processLabelsJson;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public int getTriggerType() {
        return this.triggerType;
    }

    @Generated
    public long getFixedTriggerDuration() {
        return this.fixedTriggerDuration;
    }

    @Generated
    public int getTargetType() {
        return this.targetType;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public void setLogicalId(String logicalId) {
        this.logicalId = logicalId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setProcessLabelsJson(String processLabelsJson) {
        this.processLabelsJson = processLabelsJson;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setTriggerType(int triggerType) {
        this.triggerType = triggerType;
    }

    @Generated
    public void setFixedTriggerDuration(long fixedTriggerDuration) {
        this.fixedTriggerDuration = fixedTriggerDuration;
    }

    @Generated
    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EBPFProfilingTaskRecord)) {
            return false;
        }
        EBPFProfilingTaskRecord other = (EBPFProfilingTaskRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getTriggerType() != other.getTriggerType()) {
            return false;
        }
        if (this.getFixedTriggerDuration() != other.getFixedTriggerDuration()) {
            return false;
        }
        if (this.getTargetType() != other.getTargetType()) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        String this$logicalId = this.getLogicalId();
        String other$logicalId = other.getLogicalId();
        if (this$logicalId == null ? other$logicalId != null : !this$logicalId.equals(other$logicalId)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$processLabelsJson = this.getProcessLabelsJson();
        String other$processLabelsJson = other.getProcessLabelsJson();
        if (this$processLabelsJson == null ? other$processLabelsJson != null : !this$processLabelsJson.equals(other$processLabelsJson)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        return !(this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EBPFProfilingTaskRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + this.getTriggerType();
        long $fixedTriggerDuration = this.getFixedTriggerDuration();
        result = result * 59 + (int)($fixedTriggerDuration >>> 32 ^ $fixedTriggerDuration);
        result = result * 59 + this.getTargetType();
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        String $logicalId = this.getLogicalId();
        result = result * 59 + ($logicalId == null ? 43 : $logicalId.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $processLabelsJson = this.getProcessLabelsJson();
        result = result * 59 + ($processLabelsJson == null ? 43 : $processLabelsJson.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EBPFProfilingTaskRecord(logicalId=" + this.getLogicalId() + ", serviceId=" + this.getServiceId() + ", processLabelsJson=" + this.getProcessLabelsJson() + ", instanceId=" + this.getInstanceId() + ", startTime=" + this.getStartTime() + ", triggerType=" + this.getTriggerType() + ", fixedTriggerDuration=" + this.getFixedTriggerDuration() + ", targetType=" + this.getTargetType() + ", createTime=" + this.getCreateTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + ")";
    }

    public static class Builder
    implements StorageBuilder<EBPFProfilingTaskRecord> {
        @Override
        public EBPFProfilingTaskRecord storage2Entity(Convert2Entity converter) {
            EBPFProfilingTaskRecord record = new EBPFProfilingTaskRecord();
            record.setLogicalId((String)converter.get(EBPFProfilingTaskRecord.LOGICAL_ID));
            record.setServiceId((String)converter.get(EBPFProfilingTaskRecord.SERVICE_ID));
            record.setProcessLabelsJson((String)converter.get(EBPFProfilingTaskRecord.PROCESS_LABELS_JSON));
            record.setInstanceId((String)converter.get(EBPFProfilingTaskRecord.INSTANCE_ID));
            record.setTriggerType(((Number)converter.get(EBPFProfilingTaskRecord.TRIGGER_TYPE)).intValue());
            record.setStartTime(((Number)converter.get(EBPFProfilingTaskRecord.START_TIME)).longValue());
            record.setFixedTriggerDuration(((Number)converter.get(EBPFProfilingTaskRecord.FIXED_TRIGGER_DURATION)).longValue());
            record.setTargetType(((Number)converter.get(EBPFProfilingTaskRecord.TARGET_TYPE)).intValue());
            record.setCreateTime(((Number)converter.get(EBPFProfilingTaskRecord.CREATE_TIME)).longValue());
            record.setLastUpdateTime(((Number)converter.get(EBPFProfilingTaskRecord.LAST_UPDATE_TIME)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return record;
        }

        @Override
        public void entity2Storage(EBPFProfilingTaskRecord storageData, Convert2Storage converter) {
            converter.accept(EBPFProfilingTaskRecord.LOGICAL_ID, storageData.getLogicalId());
            converter.accept(EBPFProfilingTaskRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(EBPFProfilingTaskRecord.PROCESS_LABELS_JSON, storageData.getProcessLabelsJson());
            converter.accept(EBPFProfilingTaskRecord.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(EBPFProfilingTaskRecord.TRIGGER_TYPE, storageData.getTriggerType());
            converter.accept(EBPFProfilingTaskRecord.START_TIME, storageData.getStartTime());
            converter.accept(EBPFProfilingTaskRecord.FIXED_TRIGGER_DURATION, storageData.getFixedTriggerDuration());
            converter.accept(EBPFProfilingTaskRecord.TARGET_TYPE, storageData.getTargetType());
            converter.accept(EBPFProfilingTaskRecord.CREATE_TIME, storageData.getCreateTime());
            converter.accept(EBPFProfilingTaskRecord.LAST_UPDATE_TIME, storageData.getLastUpdateTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

