/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum EBPFProfilingTargetType {
    UNKNOWN(0),
    ON_CPU(1),
    OFF_CPU(2),
    NETWORK(3);

    private final int value;
    private static final Map<Integer, EBPFProfilingTargetType> DICTIONARY;

    private EBPFProfilingTargetType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static EBPFProfilingTargetType valueOf(int value) {
        EBPFProfilingTargetType type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown EBPFProfilingTargetType value");
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, EBPFProfilingTargetType>();
        Arrays.stream(EBPFProfilingTargetType.values()).collect(Collectors.toMap(EBPFProfilingTargetType::value, type -> type)).forEach(DICTIONARY::put);
    }
}

