/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.analyze;

import com.google.common.base.Objects;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.apache.skywalking.oap.server.core.profiling.ebpf.analyze.EBPFProfilingStack;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingStackElement;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTree;

public class EBPFProfilingStackNode {
    private EBPFProfilingStack.Symbol codeSignature;
    private List<EBPFProfilingStackNode> children;
    private long dumpCount;

    public static EBPFProfilingStackNode newNode() {
        EBPFProfilingStackNode emptyNode = new EBPFProfilingStackNode();
        emptyNode.children = new ArrayList<EBPFProfilingStackNode>();
        return emptyNode;
    }

    public void accumulateFrom(EBPFProfilingStack stack) {
        List<EBPFProfilingStack.Symbol> stackList = stack.getSymbols();
        if (this.codeSignature == null) {
            this.codeSignature = stackList.get(0);
        }
        this.detectedBy(stack);
        EBPFProfilingStackNode parent = this;
        for (int depth = 1; depth < stackList.size(); ++depth) {
            EBPFProfilingStack.Symbol elementCodeSignature = stackList.get(depth);
            EBPFProfilingStackNode childElement = null;
            for (EBPFProfilingStackNode child : parent.children) {
                if (!Objects.equal((Object)child.codeSignature, (Object)elementCodeSignature)) continue;
                childElement = child;
                break;
            }
            if (childElement != null) {
                super.detectedBy(stack);
                parent = childElement;
                continue;
            }
            EBPFProfilingStackNode childNode = EBPFProfilingStackNode.newNode();
            childNode.codeSignature = elementCodeSignature;
            childNode.detectedBy(stack);
            parent.children.add(childNode);
            parent = childNode;
        }
    }

    public EBPFProfilingStackNode combine(EBPFProfilingStackNode node) {
        this.combineDetectedStacks(node);
        LinkedList<Tuple2> stack = new LinkedList<Tuple2>();
        stack.add(Tuple.of((Object)this, (Object)node));
        while (!stack.isEmpty()) {
            Tuple2 needCombineNode = (Tuple2)stack.pop();
            this.combineChildrenNodes((EBPFProfilingStackNode)needCombineNode._1, (EBPFProfilingStackNode)needCombineNode._2, stack::add);
        }
        return this;
    }

    private void combineChildrenNodes(EBPFProfilingStackNode targetNode, EBPFProfilingStackNode beingMergedNode, Consumer<Tuple2<EBPFProfilingStackNode, EBPFProfilingStackNode>> continueChildrenMerging) {
        if (beingMergedNode.children.isEmpty()) {
            return;
        }
        block0: for (EBPFProfilingStackNode childrenNode : targetNode.children) {
            ListIterator<EBPFProfilingStackNode> it = beingMergedNode.children.listIterator();
            while (it.hasNext()) {
                EBPFProfilingStackNode node = it.next();
                if (node == null || !node.matches(childrenNode)) continue;
                childrenNode.combineDetectedStacks(node);
                continueChildrenMerging.accept((Tuple2<EBPFProfilingStackNode, EBPFProfilingStackNode>)Tuple.of((Object)childrenNode, (Object)node));
                it.set(null);
                continue block0;
            }
        }
        for (EBPFProfilingStackNode node : beingMergedNode.children) {
            if (node == null) continue;
            targetNode.children.add(node);
        }
    }

    public EBPFProfilingTree buildAnalyzeResult() {
        LinkedList<Tuple2> nodeMapping = new LinkedList<Tuple2>();
        int idGenerator = 1;
        EBPFProfilingStackElement root = this.buildElement(idGenerator++);
        nodeMapping.add(new Tuple2((Object)root, (Object)this));
        LinkedList<Tuple2> stack = new LinkedList<Tuple2>();
        stack.add(Tuple.of((Object)root, (Object)this));
        while (!stack.isEmpty()) {
            Tuple2 mergingPair = (Tuple2)stack.pop();
            EBPFProfilingStackElement respElement = (EBPFProfilingStackElement)mergingPair._1;
            for (EBPFProfilingStackNode children : ((EBPFProfilingStackNode)mergingPair._2).children) {
                EBPFProfilingStackElement element = children.buildElement(idGenerator++);
                element.setParentId(respElement.getId());
                Tuple2 pair = Tuple.of((Object)element, (Object)children);
                stack.add(pair);
                nodeMapping.add(pair);
            }
        }
        EBPFProfilingTree tree = new EBPFProfilingTree();
        nodeMapping.forEach(n -> tree.getElements().add((EBPFProfilingStackElement)n._1));
        return tree;
    }

    private void detectedBy(EBPFProfilingStack stack) {
        this.dumpCount += stack.getDumpCount();
    }

    private void combineDetectedStacks(EBPFProfilingStackNode node) {
        this.dumpCount += node.dumpCount;
    }

    private EBPFProfilingStackElement buildElement(int id) {
        EBPFProfilingStackElement element = new EBPFProfilingStackElement();
        element.setId(id);
        element.setSymbol(this.codeSignature.getName());
        element.setStackType(this.codeSignature.getStackType());
        element.setDumpCount(this.dumpCount);
        return element;
    }

    private boolean matches(EBPFProfilingStackNode node) {
        return Objects.equal((Object)this.codeSignature, (Object)node.codeSignature);
    }
}

