/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.input.EBPFProfilingNetworkTaskRequest;
import org.apache.skywalking.oap.server.core.query.input.EBPFProfilingTaskFixedTimeCreationRequest;
import org.apache.skywalking.oap.server.core.query.type.EBPFNetworkKeepProfilingResult;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskCreationResult;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EBPFProfilingMutationService
implements Service {
    private static final Gson GSON = new Gson();
    public static final int FIXED_TIME_MIN_DURATION = (int)TimeUnit.SECONDS.toSeconds(60L);
    public static final int NETWORK_PROFILING_DURATION = (int)TimeUnit.MINUTES.toSeconds(10L);
    public static final int NETWORK_KEEP_ALIVE_THRESHOLD = (int)TimeUnit.SECONDS.toSeconds(60L);
    private final ModuleManager moduleManager;
    private IEBPFProfilingTaskDAO processProfilingTaskDAO;
    private IServiceLabelDAO serviceLabelDAO;
    private IMetadataQueryDAO metadataQueryDAO;

    private IEBPFProfilingTaskDAO getProcessProfilingTaskDAO() {
        if (this.processProfilingTaskDAO == null) {
            this.processProfilingTaskDAO = (IEBPFProfilingTaskDAO)this.moduleManager.find("storage").provider().getService(IEBPFProfilingTaskDAO.class);
        }
        return this.processProfilingTaskDAO;
    }

    public IServiceLabelDAO getServiceLabelDAO() {
        if (this.serviceLabelDAO == null) {
            this.serviceLabelDAO = (IServiceLabelDAO)this.moduleManager.find("storage").provider().getService(IServiceLabelDAO.class);
        }
        return this.serviceLabelDAO;
    }

    private IMetadataQueryDAO getMetadataQueryDAO() {
        if (this.metadataQueryDAO == null) {
            this.metadataQueryDAO = (IMetadataQueryDAO)this.moduleManager.find("storage").provider().getService(IMetadataQueryDAO.class);
        }
        return this.metadataQueryDAO;
    }

    public EBPFProfilingTaskCreationResult createTask(EBPFProfilingTaskFixedTimeCreationRequest request) throws IOException {
        String error;
        long current = System.currentTimeMillis();
        if (request.getStartTime() <= 0L) {
            request.setStartTime(current);
        }
        if (StringUtil.isNotEmpty((String)(error = this.checkCreateRequest(request)))) {
            return this.buildError(error);
        }
        EBPFProfilingTaskRecord task = new EBPFProfilingTaskRecord();
        task.setServiceId(request.getServiceId());
        if (CollectionUtils.isNotEmpty(request.getProcessLabels())) {
            task.setProcessLabelsJson(GSON.toJson(request.getProcessLabels()));
        } else {
            task.setProcessLabelsJson("");
        }
        task.setStartTime(request.getStartTime());
        task.setTriggerType(EBPFProfilingTriggerType.FIXED_TIME.value());
        task.setFixedTriggerDuration(request.getDuration());
        task.setTargetType(request.getTargetType().value());
        task.setCreateTime(current);
        task.setLastUpdateTime(current);
        task.setTimeBucket(TimeBucket.getMinuteTimeBucket(current));
        task.generateLogicalId();
        NoneStreamProcessor.getInstance().in(task);
        return EBPFProfilingTaskCreationResult.builder().status(true).id(task.getLogicalId()).build();
    }

    public EBPFProfilingTaskCreationResult createTask(EBPFProfilingNetworkTaskRequest request) throws IOException {
        long current = System.currentTimeMillis();
        String error = this.checkCreateRequest(request);
        if (StringUtil.isNotEmpty((String)error)) {
            return this.buildError(error);
        }
        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(request.getInstanceId());
        EBPFProfilingTaskRecord task = new EBPFProfilingTaskRecord();
        task.setServiceId(instanceIDDefinition.getServiceId());
        task.setProcessLabelsJson("");
        task.setInstanceId(request.getInstanceId());
        task.setStartTime(current);
        task.setTriggerType(EBPFProfilingTriggerType.FIXED_TIME.value());
        task.setFixedTriggerDuration(NETWORK_PROFILING_DURATION);
        task.setTargetType(EBPFProfilingTargetType.NETWORK.value());
        task.setCreateTime(current);
        task.setLastUpdateTime(current);
        task.setTimeBucket(TimeBucket.getMinuteTimeBucket(current));
        task.generateLogicalId();
        NoneStreamProcessor.getInstance().in(task);
        return EBPFProfilingTaskCreationResult.builder().status(true).id(task.getLogicalId()).build();
    }

    public EBPFNetworkKeepProfilingResult keepEBPFNetworkProfiling(String taskId) throws IOException {
        EBPFProfilingTask task = this.getProcessProfilingTaskDAO().queryById(taskId);
        if (task == null) {
            return this.buildKeepProfilingError("profiling task not exists");
        }
        if (!Objects.equals((Object)task.getTargetType(), (Object)EBPFProfilingTargetType.NETWORK)) {
            return this.buildKeepProfilingError("current task is not a \"NETWORK\" task");
        }
        Calendar taskTime = Calendar.getInstance();
        taskTime.setTimeInMillis(task.getTaskStartTime());
        taskTime.add(13, (int)task.getFixedTriggerDuration());
        Calendar now = Calendar.getInstance();
        long sec = TimeUnit.MILLISECONDS.toSeconds(taskTime.getTimeInMillis() - now.getTimeInMillis());
        if (sec < 0L) {
            return this.buildKeepProfilingError("profiling task has been finished");
        }
        if (sec > (long)NETWORK_KEEP_ALIVE_THRESHOLD) {
            return this.buildKeepProfilingSuccess();
        }
        EBPFProfilingTaskRecord record = new EBPFProfilingTaskRecord();
        record.setLogicalId(task.getTaskId());
        record.setServiceId(task.getServiceId());
        record.setProcessLabelsJson("");
        record.setInstanceId(task.getServiceInstanceId());
        record.setStartTime(task.getTaskStartTime());
        record.setTriggerType(task.getTriggerType().value());
        record.setFixedTriggerDuration(task.getFixedTriggerDuration() + (long)NETWORK_PROFILING_DURATION);
        record.setTargetType(EBPFProfilingTargetType.NETWORK.value());
        record.setCreateTime(now.getTimeInMillis());
        record.setLastUpdateTime(now.getTimeInMillis());
        NoneStreamProcessor.getInstance().in(record);
        return this.buildKeepProfilingSuccess();
    }

    private EBPFProfilingTaskCreationResult buildError(String msg) {
        return EBPFProfilingTaskCreationResult.builder().status(false).errorReason(msg).build();
    }

    private EBPFNetworkKeepProfilingResult buildKeepProfilingError(String msg) {
        return EBPFNetworkKeepProfilingResult.builder().status(false).errorReason(msg).build();
    }

    private EBPFNetworkKeepProfilingResult buildKeepProfilingSuccess() {
        return EBPFNetworkKeepProfilingResult.builder().status(true).build();
    }

    private String checkCreateRequest(EBPFProfilingTaskFixedTimeCreationRequest request) throws IOException {
        EBPFProfilingTask mostRecentTask;
        String err = null;
        if ((err = this.requiredNotEmpty(err, "service", request.getServiceId())) == null && CollectionUtils.isNotEmpty(request.getProcessLabels())) {
            List<String> existingLabels = this.getServiceLabelDAO().queryAllLabels(request.getServiceId());
            ArrayList<String> notExistLabels = new ArrayList<String>(existingLabels.size());
            for (String processLabel : request.getProcessLabels()) {
                if (existingLabels.contains(processLabel)) continue;
                notExistLabels.add(processLabel);
            }
            if (notExistLabels.size() > 0) {
                err = String.format("The service doesn't have processes with label(s) %s.", Joiner.on((String)", ").join(notExistLabels));
            } else {
                String labelJson = GSON.toJson(request.getProcessLabels());
                if (labelJson.length() > 1000) {
                    err = String.format("The labels length is bigger than %d, please reduce the labels count", 1000);
                }
            }
        }
        if (err != null) {
            return err;
        }
        err = this.validateTargetType(request);
        if (err != null) {
            return err;
        }
        err = this.validateTriggerType(request);
        if (err != null) {
            return err;
        }
        List<EBPFProfilingTask> tasks = this.getProcessProfilingTaskDAO().queryTasksByTargets(request.getServiceId(), null, Arrays.asList(request.getTargetType()), request.getStartTime(), 0L);
        if (CollectionUtils.isNotEmpty(tasks) && (mostRecentTask = tasks.stream().min(Comparator.comparingLong(EBPFProfilingTask::getTaskStartTime)).get()).getTaskStartTime() < this.calculateStartTime(request)) {
            return "Task's time range overlaps with other tasks";
        }
        return null;
    }

    private String checkCreateRequest(EBPFProfilingNetworkTaskRequest request) throws IOException {
        String err = null;
        if (StringUtil.isNotEmpty((String)(err = this.requiredNotEmpty(err, "instance", request.getInstanceId())))) {
            return err;
        }
        long processesCount = this.getMetadataQueryDAO().getProcessCount(request.getInstanceId());
        if (processesCount <= 0L) {
            return "The instance doesn't have processes.";
        }
        return null;
    }

    private long calculateStartTime(EBPFProfilingTaskFixedTimeCreationRequest request) {
        return request.getStartTime() - TimeUnit.SECONDS.toMillis(request.getDuration());
    }

    private String validateTriggerType(EBPFProfilingTaskFixedTimeCreationRequest request) {
        if (request.getDuration() < FIXED_TIME_MIN_DURATION) {
            return "the fixed time duration must be greater than or equals " + FIXED_TIME_MIN_DURATION + "s";
        }
        return null;
    }

    private String requiredNotEmpty(String error, String type, String data) {
        if (StringUtil.isNotEmpty((String)error)) {
            return error;
        }
        return StringUtil.isNotEmpty((String)data) ? null : String.format("%s could not be empty", type);
    }

    private String validateTargetType(EBPFProfilingTaskFixedTimeCreationRequest request) {
        if (request.getTargetType() == null) {
            return "the profiling target could not be null";
        }
        return null;
    }

    @Generated
    public EBPFProfilingMutationService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

