/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.logging;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.core.logging.log4j.OapConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfigWatcher
extends ConfigChangeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingConfigWatcher.class);
    private final LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
    private final OapConfiguration originConfiguration = (OapConfiguration)this.ctx.getConfiguration();
    private volatile String content;

    public LoggingConfigWatcher(ModuleProvider provider) {
        super("core", provider, "log4j-xml");
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        String newValue;
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.content = null;
            newValue = null;
        } else {
            this.content = value.getNewValue();
            newValue = value.getNewValue();
        }
        try {
            if (!this.reconfigure(newValue)) {
                return;
            }
        }
        catch (Throwable t) {
            log.error("failed to apply configuration to log4j", t);
            return;
        }
    }

    public String value() {
        return this.content;
    }

    private boolean reconfigure(String newValue) {
        OapConfiguration oc;
        if (Strings.isNullOrEmpty((String)newValue)) {
            if (this.ctx.getConfiguration().equals((Object)this.originConfiguration)) {
                return false;
            }
            this.ctx.onChange((Reconfigurable)this.originConfiguration);
            return true;
        }
        try {
            oc = new OapConfiguration(this.ctx, new ConfigurationSource((InputStream)new ByteArrayInputStream(newValue.getBytes())));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("failed to parse %s from configuration center", newValue), e);
        }
        oc.initialize();
        this.ctx.onChange((Reconfigurable)oc);
        return true;
    }
}

