/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group.openapi;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringFormatGroup;

public class EndpointGroupingRule4Openapi {
    private final Map<String, Map<String, String>> directLookup = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, StringFormatGroup>> groupedRules = new HashMap<String, Map<String, StringFormatGroup>>();

    void addDirectLookup(String serviceName, String endpointName, String endpointGroupName) {
        Map endpointNameLookup = this.directLookup.computeIfAbsent(serviceName, name -> new HashMap());
        endpointNameLookup.put(endpointName, endpointGroupName);
    }

    void addGroupedRule(String serviceName, String endpointGroupName, String ruleRegex) {
        String rulesGroupkey = this.getGroupedRulesKey(ruleRegex);
        Map rules = this.groupedRules.computeIfAbsent(serviceName, name -> new HashMap());
        StringFormatGroup formatGroup = rules.computeIfAbsent(rulesGroupkey, name -> new StringFormatGroup());
        formatGroup.addRule(endpointGroupName, ruleRegex);
    }

    public StringFormatGroup.FormatResult format(String service, String endpointName) {
        StringFormatGroup stringFormatGroup;
        Map<String, String> endpointNameLookup = this.directLookup.get(service);
        if (endpointNameLookup != null && endpointNameLookup.get(endpointName) != null) {
            return new StringFormatGroup.FormatResult(true, endpointNameLookup.get(endpointName), endpointName);
        }
        Map<String, StringFormatGroup> rules = this.groupedRules.get(service);
        if (rules != null && (stringFormatGroup = rules.get(this.getGroupedRulesKey(endpointName))) != null) {
            return stringFormatGroup.format(endpointName);
        }
        return new StringFormatGroup.FormatResult(false, endpointName, endpointName);
    }

    void sortRulesAll() {
        this.groupedRules.entrySet().forEach(rules -> this.sortRulesByService((String)rules.getKey()));
    }

    void sortRulesByService(String serviceName) {
        Map<String, StringFormatGroup> rules = this.groupedRules.get(serviceName);
        if (rules != null) {
            rules.entrySet().forEach(stringFormatGroup -> ((StringFormatGroup)stringFormatGroup.getValue()).sortRules((Comparator)new EndpointGroupingRulesComparator()));
        }
    }

    String getGroupedRulesKey(String string) {
        String[] ss = string.split("/");
        if (ss.length == 1) {
            return ss[0] + "/";
        }
        if (ss.length > 1) {
            return ss[0] + "/" + ss[1];
        }
        return "/";
    }

    @Generated
    public Map<String, Map<String, StringFormatGroup>> getGroupedRules() {
        return this.groupedRules;
    }

    static class EndpointGroupingRulesComparator
    implements Comparator<StringFormatGroup.PatternRule> {
        private static final String VAR_PATTERN = "\\(\\[\\^\\/\\]\\+\\)";

        EndpointGroupingRulesComparator() {
        }

        @Override
        public int compare(StringFormatGroup.PatternRule rule1, StringFormatGroup.PatternRule rule2) {
            String pattern1 = rule1.getPattern().pattern();
            String pattern2 = rule2.getPattern().pattern();
            if (this.getPatternVarsCount(pattern1) < this.getPatternVarsCount(pattern2)) {
                return -1;
            }
            if (this.getPatternVarsCount(pattern1) > this.getPatternVarsCount(pattern2)) {
                return 1;
            }
            int length1 = this.getPatternLength(pattern1);
            int length2 = this.getPatternLength(pattern2);
            return length2 - length1;
        }

        private int getPatternVarsCount(String pattern) {
            return ",".concat(pattern).concat(",").split(VAR_PATTERN).length - 1;
        }

        private int getPatternLength(String pattern) {
            return pattern.replaceAll(VAR_PATTERN, "#").length();
        }
    }
}

