/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.group.EndpointGroupingRule;
import org.apache.skywalking.oap.server.core.config.group.openapi.EndpointGroupingRule4Openapi;
import org.apache.skywalking.oap.server.library.util.StringFormatGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointNameGrouping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointNameGrouping.class);
    private volatile EndpointGroupingRule endpointGroupingRule;
    private volatile EndpointGroupingRule4Openapi endpointGroupingRule4Openapi;

    public String format(String serviceName, String endpointName) {
        String formattedName = endpointName;
        if (this.endpointGroupingRule4Openapi != null) {
            formattedName = this.formatByOpenapi(serviceName, formattedName);
        }
        if (this.endpointGroupingRule != null) {
            formattedName = this.formatByCustom(serviceName, formattedName);
        }
        return formattedName;
    }

    private String formatByCustom(String serviceName, String endpointName) {
        StringFormatGroup.FormatResult formatResult = this.endpointGroupingRule.format(serviceName, endpointName);
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            if (formatResult.isMatch()) {
                log.debug("Endpoint {} of Service {} has been renamed in group {} by endpointGroupingRule", new Object[]{endpointName, serviceName, formatResult.getName()});
            } else {
                log.trace("Endpoint {} of Service {} keeps unchanged.", (Object)endpointName, (Object)serviceName);
            }
        }
        return formatResult.getName();
    }

    private String formatByOpenapi(String serviceName, String endpointName) {
        StringFormatGroup.FormatResult formatResult = this.endpointGroupingRule4Openapi.format(serviceName, endpointName);
        if (log.isDebugEnabled() || log.isTraceEnabled()) {
            if (formatResult.isMatch()) {
                log.debug("Endpoint {} of Service {} has been renamed in group {} by endpointGroupingRule4Openapi", new Object[]{endpointName, serviceName, formatResult.getName()});
            } else {
                log.trace("Endpoint {} of Service {} keeps unchanged.", (Object)endpointName, (Object)serviceName);
            }
        }
        return formatResult.getName();
    }

    @Generated
    public void setEndpointGroupingRule(EndpointGroupingRule endpointGroupingRule) {
        this.endpointGroupingRule = endpointGroupingRule;
    }

    @Generated
    public void setEndpointGroupingRule4Openapi(EndpointGroupingRule4Openapi endpointGroupingRule4Openapi) {
        this.endpointGroupingRule4Openapi = endpointGroupingRule4Openapi;
    }
}

