/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.config.group.EndpointGroupingRule;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class EndpointGroupingRuleReader {
    private Map yamlData;

    public EndpointGroupingRuleReader(InputStream inputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        this.yamlData = (Map)yaml.load(inputStream);
    }

    public EndpointGroupingRuleReader(Reader io) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        this.yamlData = (Map)yaml.load(io);
    }

    EndpointGroupingRule read() {
        List rulesData;
        EndpointGroupingRule endpointGroupingRule = new EndpointGroupingRule();
        if (Objects.nonNull(this.yamlData) && (rulesData = (List)this.yamlData.get("grouping")) != null) {
            rulesData.forEach(ruleObj -> {
                Map rule = (Map)ruleObj;
                String serviceName = (String)rule.get("service-name");
                if (StringUtil.isEmpty((String)serviceName)) {
                    throw new IllegalArgumentException("service-name can't be empty");
                }
                List endpointRules = (List)rule.get("rules");
                if (endpointRules != null) {
                    endpointRules.forEach(endpointRuleObj -> {
                        Map endpointRule = (Map)endpointRuleObj;
                        String endpointLogicGroupName = (String)endpointRule.get("endpoint-name");
                        String groupRegex = (String)endpointRule.get("regex");
                        if (StringUtil.isEmpty((String)endpointLogicGroupName) || StringUtil.isEmpty((String)groupRegex)) {
                            return;
                        }
                        endpointGroupingRule.addRule(serviceName, endpointLogicGroupName, groupRegex);
                    });
                }
            });
        }
        return endpointGroupingRule;
    }
}

