/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.library.util.StringFormatGroup;

public class EndpointGroupingRule {
    private Map<String, StringFormatGroup> rules = new HashMap<String, StringFormatGroup>();

    void addRule(String serviceName, String endpointGroupName, String ruleRegex) {
        StringFormatGroup formatGroup = this.rules.computeIfAbsent(serviceName, name -> new StringFormatGroup());
        formatGroup.addRule(endpointGroupName, ruleRegex);
    }

    public StringFormatGroup.FormatResult format(String service, String endpointName) {
        StringFormatGroup stringFormatGroup = this.rules.get(service);
        if (stringFormatGroup != null) {
            return stringFormatGroup.format(endpointName);
        }
        return new StringFormatGroup.FormatResult(false, endpointName, endpointName);
    }
}

