/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.command;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.network.trace.component.command.EBPFProfilingTaskCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.ProfileTaskCommand;

public class CommandService
implements Service {
    private final ModuleManager moduleManager;

    public CommandService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public ProfileTaskCommand newProfileTaskCommand(ProfileTask task) {
        String serialNumber = UUID.randomUUID().toString();
        return new ProfileTaskCommand(serialNumber, task.getId(), task.getEndpointName(), task.getDuration(), task.getMinDurationThreshold(), task.getDumpPeriod(), task.getMaxSamplingCount(), task.getStartTime(), task.getCreateTime());
    }

    public EBPFProfilingTaskCommand newEBPFProfilingTaskCommand(EBPFProfilingTask task, List<String> processId) {
        String serialNumber = UUID.randomUUID().toString();
        EBPFProfilingTaskCommand.FixedTrigger fixedTrigger = null;
        if (Objects.equals((Object)task.getTriggerType(), (Object)EBPFProfilingTriggerType.FIXED_TIME)) {
            fixedTrigger = new EBPFProfilingTaskCommand.FixedTrigger(task.getFixedTriggerDuration());
        }
        return new EBPFProfilingTaskCommand(serialNumber, task.getTaskId(), processId, task.getTaskStartTime(), task.getLastUpdateTime(), task.getTriggerType().name(), fixedTrigger, task.getTargetType().name());
    }

    private String generateSerialNumber(int serviceInstanceId, long time, String serviceInstanceUUID) {
        return UUID.randomUUID().toString();
    }
}

