/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskCache
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileTaskCache.class);
    private final Cache<String, List<ProfileTask>> profileTaskDownstreamCache;
    private final Cache<String, ProfileTask> profileTaskIdCache;
    private final ModuleManager moduleManager;
    private IProfileTaskQueryDAO profileTaskQueryDAO;

    public ProfileTaskCache(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        long initialSize = moduleConfig.getMaxSizeOfProfileTask() / 10L;
        int initialCapacitySize = (int)(initialSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : initialSize);
        this.profileTaskDownstreamCache = CacheBuilder.newBuilder().initialCapacity(initialCapacitySize).maximumSize(moduleConfig.getMaxSizeOfProfileTask()).expireAfterWrite(Duration.ofMinutes(1L)).build();
        this.profileTaskIdCache = CacheBuilder.newBuilder().initialCapacity(initialCapacitySize).maximumSize(moduleConfig.getMaxSizeOfProfileTask()).build();
    }

    private IProfileTaskQueryDAO getProfileTaskQueryDAO() {
        if (Objects.isNull(this.profileTaskQueryDAO)) {
            this.profileTaskQueryDAO = (IProfileTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskQueryDAO.class);
        }
        return this.profileTaskQueryDAO;
    }

    public List<ProfileTask> getProfileTaskList(String serviceId) {
        List profileTaskList = (List)this.profileTaskDownstreamCache.getIfPresent((Object)serviceId);
        return profileTaskList;
    }

    public ProfileTask getProfileTaskById(String id) {
        ProfileTask profile = (ProfileTask)this.profileTaskIdCache.getIfPresent((Object)id);
        if (profile == null) {
            try {
                profile = this.getProfileTaskQueryDAO().getById(id);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (profile != null) {
                this.profileTaskIdCache.put((Object)id, (Object)profile);
            }
        }
        return profile;
    }

    public void saveTaskList(String serviceId, List<ProfileTask> taskList) {
        if (taskList == null) {
            taskList = Collections.emptyList();
        }
        this.profileTaskDownstreamCache.put((Object)serviceId, taskList);
    }

    public long getCacheStartTimeBucket() {
        return TimeBucket.getMinuteTimeBucket(System.currentTimeMillis());
    }

    public long getCacheEndTimeBucket() {
        return TimeBucket.getMinuteTimeBucket(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(25L));
    }
}

