/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class TopNStreamProcessor
implements StreamProcessor<TopN> {
    private static final TopNStreamProcessor PROCESSOR = new TopNStreamProcessor();
    private List<TopNWorker> persistentWorkers = new ArrayList<TopNWorker>();
    private Map<Class<? extends Record>, TopNWorker> workers = new HashMap<Class<? extends Record>, TopNWorker>();
    private int topNWorkerReportCycle = 10;
    private int topSize = 50;

    public static TopNStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends TopN> topNClass) throws StorageException {
        IRecordDAO recordDAO;
        StorageBuilderFactory storageBuilderFactory = (StorageBuilderFactory)moduleDefineHolder.find("storage").provider().getService(StorageBuilderFactory.class);
        Class<? extends StorageBuilder> builder = storageBuilderFactory.builderOf(topNClass, stream.builder());
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            recordDAO = storageDAO.newRecordDao(builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " top n record DAO failure.", e);
        }
        ModelCreator modelSetter = (ModelCreator)moduleDefineHolder.find("core").provider().getService(ModelCreator.class);
        Model model = modelSetter.add(topNClass, stream.scopeId(), new Storage(stream.name(), false, DownSampling.Second), true);
        TopNWorker persistentWorker = new TopNWorker(moduleDefineHolder, model, this.topSize, (long)(this.topNWorkerReportCycle * 60) * 1000L, recordDAO);
        this.persistentWorkers.add(persistentWorker);
        this.workers.put(topNClass, persistentWorker);
    }

    @Override
    public void in(TopN topN) {
        TopNWorker worker = this.workers.get(topN.getClass());
        if (worker != null) {
            worker.in(topN);
        }
    }

    @Generated
    public List<TopNWorker> getPersistentWorkers() {
        return this.persistentWorkers;
    }

    @Generated
    public void setTopNWorkerReportCycle(int topNWorkerReportCycle) {
        this.topNWorkerReportCycle = topNWorkerReportCycle;
    }

    @Generated
    public int getTopNWorkerReportCycle() {
        return this.topNWorkerReportCycle;
    }

    @Generated
    public void setTopSize(int topSize) {
        this.topSize = topSize;
    }

    @Generated
    public int getTopSize() {
        return this.topSize;
    }
}

