/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamPersistentWorker;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class NoneStreamProcessor
implements StreamProcessor<NoneStream> {
    private static final NoneStreamProcessor PROCESSOR = new NoneStreamProcessor();
    private Map<Class<? extends NoneStream>, NoneStreamPersistentWorker> workers = new HashMap<Class<? extends NoneStream>, NoneStreamPersistentWorker>();

    public static NoneStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(NoneStream noneStream) {
        NoneStreamPersistentWorker worker = this.workers.get(noneStream.getClass());
        if (worker != null) {
            worker.in(noneStream);
        }
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends NoneStream> streamClass) throws StorageException {
        INoneStreamDAO noneStream;
        StorageBuilderFactory storageBuilderFactory = (StorageBuilderFactory)moduleDefineHolder.find("storage").provider().getService(StorageBuilderFactory.class);
        Class<? extends StorageBuilder> builder = storageBuilderFactory.builderOf(streamClass, stream.builder());
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            noneStream = storageDAO.newNoneStreamDao(builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " none stream record DAO failure.", e);
        }
        ModelCreator modelSetter = (ModelCreator)moduleDefineHolder.find("core").provider().getService(ModelCreator.class);
        Model model = modelSetter.add(streamClass, stream.scopeId(), new Storage(stream.name(), false, DownSampling.Minute), true);
        NoneStreamPersistentWorker persistentWorker = new NoneStreamPersistentWorker(moduleDefineHolder, model, noneStream);
        this.workers.put(streamClass, persistentWorker);
    }
}

