/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamDefinition;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.AlarmNotifyWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.ExportWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsAggregateWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsPersistentWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsRemoteWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsTransWorker;
import org.apache.skywalking.oap.server.core.config.DownSamplingConfigService;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceSetter;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class MetricsStreamProcessor
implements StreamProcessor<Metrics> {
    private static final MetricsStreamProcessor PROCESSOR = new MetricsStreamProcessor();
    private Map<Class<? extends Metrics>, MetricsAggregateWorker> entryWorkers = new HashMap<Class<? extends Metrics>, MetricsAggregateWorker>();
    private List<MetricsPersistentWorker> persistentWorkers = new ArrayList<MetricsPersistentWorker>();
    private long l1FlushPeriod = 500L;
    private boolean enableDatabaseSession;
    private long storageSessionTimeout = 70000L;
    private int metricsDataTTL = 3;

    public static MetricsStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(Metrics metrics) {
        MetricsAggregateWorker worker = this.entryWorkers.get(metrics.getClass());
        if (worker != null) {
            worker.in(metrics);
        }
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends Metrics> metricsClass) throws StorageException {
        this.create(moduleDefineHolder, StreamDefinition.from(stream), metricsClass);
    }

    public void create(ModuleDefineHolder moduleDefineHolder, StreamDefinition stream, Class<? extends Metrics> metricsClass) throws StorageException {
        Model model;
        IMetricsDAO metricsDAO;
        StorageBuilderFactory storageBuilderFactory = (StorageBuilderFactory)moduleDefineHolder.find("storage").provider().getService(StorageBuilderFactory.class);
        Class<? extends StorageBuilder> builder = storageBuilderFactory.builderOf(metricsClass, stream.getBuilder());
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            metricsDAO = storageDAO.newMetricsDao(builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnexpectedException("Create " + stream.getBuilder().getSimpleName() + " metrics DAO failure.", e);
        }
        ModelCreator modelSetter = (ModelCreator)moduleDefineHolder.find("core").provider().getService(ModelCreator.class);
        DownSamplingConfigService configService = (DownSamplingConfigService)moduleDefineHolder.find("core").provider().getService(DownSamplingConfigService.class);
        MetricsPersistentWorker hourPersistentWorker = null;
        MetricsPersistentWorker dayPersistentWorker = null;
        MetricsTransWorker transWorker = null;
        MetricsExtension metricsExtension = metricsClass.getAnnotation(MetricsExtension.class);
        boolean supportDownSampling = true;
        boolean supportUpdate = true;
        boolean timeRelativeID = true;
        if (metricsExtension != null) {
            supportDownSampling = metricsExtension.supportDownSampling();
            supportUpdate = metricsExtension.supportUpdate();
            timeRelativeID = metricsExtension.timeRelativeID();
        }
        if (supportDownSampling) {
            if (configService.shouldToHour()) {
                model = modelSetter.add(metricsClass, stream.getScopeId(), new Storage(stream.getName(), timeRelativeID, DownSampling.Hour), false);
                hourPersistentWorker = this.downSamplingWorker(moduleDefineHolder, metricsDAO, model, supportUpdate);
            }
            if (configService.shouldToDay()) {
                model = modelSetter.add(metricsClass, stream.getScopeId(), new Storage(stream.getName(), timeRelativeID, DownSampling.Day), false);
                dayPersistentWorker = this.downSamplingWorker(moduleDefineHolder, metricsDAO, model, supportUpdate);
            }
            transWorker = new MetricsTransWorker(moduleDefineHolder, hourPersistentWorker, dayPersistentWorker);
        }
        model = modelSetter.add(metricsClass, stream.getScopeId(), new Storage(stream.getName(), timeRelativeID, DownSampling.Minute), false);
        MetricsPersistentWorker minutePersistentWorker = this.minutePersistentWorker(moduleDefineHolder, metricsDAO, model, transWorker, supportUpdate);
        String remoteReceiverWorkerName = stream.getName() + "_rec";
        IWorkerInstanceSetter workerInstanceSetter = (IWorkerInstanceSetter)moduleDefineHolder.find("core").provider().getService(IWorkerInstanceSetter.class);
        workerInstanceSetter.put(remoteReceiverWorkerName, minutePersistentWorker, metricsClass);
        MetricsRemoteWorker remoteWorker = new MetricsRemoteWorker(moduleDefineHolder, remoteReceiverWorkerName);
        MetricsAggregateWorker aggregateWorker = new MetricsAggregateWorker(moduleDefineHolder, remoteWorker, stream.getName(), this.l1FlushPeriod);
        this.entryWorkers.put(metricsClass, aggregateWorker);
    }

    private MetricsPersistentWorker minutePersistentWorker(ModuleDefineHolder moduleDefineHolder, IMetricsDAO metricsDAO, Model model, MetricsTransWorker transWorker, boolean supportUpdate) {
        AlarmNotifyWorker alarmNotifyWorker = new AlarmNotifyWorker(moduleDefineHolder);
        ExportWorker exportWorker = new ExportWorker(moduleDefineHolder);
        MetricsPersistentWorker minutePersistentWorker = new MetricsPersistentWorker(moduleDefineHolder, model, metricsDAO, alarmNotifyWorker, exportWorker, transWorker, this.enableDatabaseSession, supportUpdate, this.storageSessionTimeout, this.metricsDataTTL);
        this.persistentWorkers.add(minutePersistentWorker);
        return minutePersistentWorker;
    }

    private MetricsPersistentWorker downSamplingWorker(ModuleDefineHolder moduleDefineHolder, IMetricsDAO metricsDAO, Model model, boolean supportUpdate) {
        MetricsPersistentWorker persistentWorker = new MetricsPersistentWorker(moduleDefineHolder, model, metricsDAO, this.enableDatabaseSession, supportUpdate, this.storageSessionTimeout, this.metricsDataTTL);
        this.persistentWorkers.add(persistentWorker);
        return persistentWorker;
    }

    @Generated
    public List<MetricsPersistentWorker> getPersistentWorkers() {
        return this.persistentWorkers;
    }

    @Generated
    public void setL1FlushPeriod(long l1FlushPeriod) {
        this.l1FlushPeriod = l1FlushPeriod;
    }

    @Generated
    public long getL1FlushPeriod() {
        return this.l1FlushPeriod;
    }

    @Generated
    public void setEnableDatabaseSession(boolean enableDatabaseSession) {
        this.enableDatabaseSession = enableDatabaseSession;
    }

    @Generated
    public boolean isEnableDatabaseSession() {
        return this.enableDatabaseSession;
    }

    @Generated
    public void setStorageSessionTimeout(long storageSessionTimeout) {
        this.storageSessionTimeout = storageSessionTimeout;
    }

    @Generated
    public void setMetricsDataTTL(int metricsDataTTL) {
        this.metricsDataTTL = metricsDataTTL;
    }
}

