/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.MergableBufferedData;
import org.apache.skywalking.oap.server.core.analysis.data.ReadWriteSafeCache;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsTransWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.exporter.ExportEvent;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPersistentWorker
extends PersistenceWorker<Metrics> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsPersistentWorker.class);
    private static long SESSION_TIMEOUT_OFFSITE_COUNTER = 0L;
    private final Model model;
    private final Map<Metrics, Metrics> context;
    private final IMetricsDAO metricsDAO;
    private final Optional<AbstractWorker<Metrics>> nextAlarmWorker;
    private final Optional<AbstractWorker<ExportEvent>> nextExportWorker;
    private final DataCarrier<Metrics> dataCarrier;
    private final Optional<MetricsTransWorker> transWorker;
    private final boolean enableDatabaseSession;
    private final boolean supportUpdate;
    private long sessionTimeout;
    private CounterMetrics aggregationCounter;
    private int persistentCounter;
    private int persistentMod;
    private int metricsDataTTL;

    MetricsPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, IMetricsDAO metricsDAO, AbstractWorker<Metrics> nextAlarmWorker, AbstractWorker<ExportEvent> nextExportWorker, MetricsTransWorker transWorker, boolean enableDatabaseSession, boolean supportUpdate, long storageSessionTimeout, int metricsDataTTL) {
        super(moduleDefineHolder, new ReadWriteSafeCache(new MergableBufferedData(), new MergableBufferedData()));
        this.model = model;
        this.context = new HashMap<Metrics, Metrics>(100);
        this.enableDatabaseSession = enableDatabaseSession;
        this.metricsDAO = metricsDAO;
        this.nextAlarmWorker = Optional.ofNullable(nextAlarmWorker);
        this.nextExportWorker = Optional.ofNullable(nextExportWorker);
        this.transWorker = Optional.ofNullable(transWorker);
        this.supportUpdate = supportUpdate;
        this.sessionTimeout = storageSessionTimeout;
        this.persistentCounter = 0;
        this.persistentMod = 1;
        this.metricsDataTTL = metricsDataTTL;
        String name = "METRICS_L2_AGGREGATION";
        int size = BulkConsumePool.Creator.recommendMaxSize() / 8;
        if (size == 0) {
            size = 1;
        }
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, size, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier = new DataCarrier("MetricsPersistentWorker." + model.getName(), name, 1, 2000);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new PersistentConsumer());
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.aggregationCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{model.getName(), "2", model.getDownsampling().getName()}));
        ++SESSION_TIMEOUT_OFFSITE_COUNTER;
    }

    MetricsPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, IMetricsDAO metricsDAO, boolean enableDatabaseSession, boolean supportUpdate, long storageSessionTimeout, int metricsDataTTL) {
        this(moduleDefineHolder, model, metricsDAO, null, null, null, enableDatabaseSession, supportUpdate, storageSessionTimeout, metricsDataTTL);
        this.sessionTimeout = this.sessionTimeout * 4L + SESSION_TIMEOUT_OFFSITE_COUNTER * 200L;
        this.persistentMod = 4;
    }

    @Override
    public void in(Metrics metrics) {
        this.aggregationCounter.inc();
        this.dataCarrier.produce((Object)metrics);
    }

    @Override
    public List<PrepareRequest> buildBatchRequests() {
        if (this.persistentCounter++ % this.persistentMod != 0) {
            return Collections.emptyList();
        }
        List lastCollection = this.getCache().read();
        long start = System.currentTimeMillis();
        if (lastCollection.size() == 0) {
            return Collections.emptyList();
        }
        int maxBatchGetSize = 2000;
        int batchSize = Math.min(maxBatchGetSize, lastCollection.size());
        ArrayList<Metrics> metricsList = new ArrayList<Metrics>();
        ArrayList<PrepareRequest> prepareRequests = new ArrayList<PrepareRequest>(lastCollection.size());
        for (Metrics data : lastCollection) {
            this.transWorker.ifPresent(metricsTransWorker -> metricsTransWorker.in(data));
            metricsList.add(data);
            if (metricsList.size() != batchSize) continue;
            this.flushDataToStorage(metricsList, prepareRequests);
        }
        if (metricsList.size() > 0) {
            this.flushDataToStorage(metricsList, prepareRequests);
        }
        if (prepareRequests.size() > 0) {
            log.debug("prepare batch requests for model {}, took time: {}, size: {}", new Object[]{this.model.getName(), System.currentTimeMillis() - start, prepareRequests.size()});
        }
        return prepareRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDataToStorage(List<Metrics> metricsList, List<PrepareRequest> prepareRequests) {
        try {
            this.loadFromStorage(metricsList);
            long timestamp = System.currentTimeMillis();
            for (Metrics metrics : metricsList) {
                Metrics cachedMetrics = this.context.get(metrics);
                if (cachedMetrics != null) {
                    boolean isAbandoned;
                    if (!this.supportUpdate) continue;
                    boolean bl = isAbandoned = !cachedMetrics.combine(metrics);
                    if (isAbandoned) continue;
                    cachedMetrics.calculate();
                    prepareRequests.add((PrepareRequest)this.metricsDAO.prepareBatchUpdate(this.model, cachedMetrics));
                    this.nextWorker(cachedMetrics);
                    cachedMetrics.setLastUpdateTimestamp(timestamp);
                } else {
                    metrics.calculate();
                    prepareRequests.add((PrepareRequest)this.metricsDAO.prepareBatchInsert(this.model, metrics));
                    this.nextWorker(metrics);
                    metrics.setLastUpdateTimestamp(timestamp);
                }
                this.nextExportWorker.ifPresent(exportEvenWorker -> exportEvenWorker.in(new ExportEvent(metrics, ExportEvent.EventType.INCREMENT)));
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        finally {
            metricsList.clear();
        }
    }

    private void nextWorker(Metrics metrics) {
        this.nextAlarmWorker.ifPresent(nextAlarmWorker -> nextAlarmWorker.in(metrics));
        this.nextExportWorker.ifPresent(nextExportWorker -> nextExportWorker.in(new ExportEvent(metrics, ExportEvent.EventType.TOTAL)));
    }

    private void loadFromStorage(List<Metrics> metrics) {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            List<Metrics> notInCacheMetrics = metrics.stream().filter(m -> {
                Metrics cachedValue = this.context.get(m);
                if (cachedValue == null || !this.enableDatabaseSession) {
                    return true;
                }
                if (!this.model.isTimeRelativeID() && this.supportUpdate && this.metricsDAO.isExpiredCache(this.model, cachedValue, currentTimeMillis, this.metricsDataTTL)) {
                    this.context.remove(m);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            if (notInCacheMetrics.isEmpty()) {
                return;
            }
            List<Metrics> dbMetrics = this.metricsDAO.multiGet(this.model, notInCacheMetrics);
            if (!this.enableDatabaseSession) {
                this.context.clear();
            }
            dbMetrics.forEach(m -> this.context.put((Metrics)m, (Metrics)m));
        }
        catch (Exception e) {
            log.error("Failed to load metrics for merging", (Throwable)e);
        }
    }

    @Override
    public void endOfRound() {
        if (this.enableDatabaseSession) {
            Iterator<Metrics> iterator = this.context.values().iterator();
            long timestamp = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Metrics metrics = iterator.next();
                if (!metrics.isExpired(timestamp, this.sessionTimeout)) continue;
                iterator.remove();
            }
        }
    }

    private class PersistentConsumer
    implements IConsumer<Metrics> {
        private PersistentConsumer() {
        }

        public void init(Properties properties) {
        }

        public void consume(List<Metrics> data) {
            MetricsPersistentWorker.this.onWork(data);
        }

        public void onError(List<Metrics> data, Throwable t) {
            log.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

