/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.analysis.worker.ManagementPersistentWorker;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class ManagementStreamProcessor
implements StreamProcessor<ManagementData> {
    private static final ManagementStreamProcessor PROCESSOR = new ManagementStreamProcessor();
    private Map<Class<? extends ManagementData>, ManagementPersistentWorker> workers = new HashMap<Class<? extends ManagementData>, ManagementPersistentWorker>();

    public static ManagementStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(ManagementData managementData) {
        ManagementPersistentWorker worker = this.workers.get(managementData.getClass());
        if (worker != null) {
            worker.in(managementData);
        }
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends ManagementData> streamClass) throws StorageException {
        IManagementDAO managementDAO;
        StorageBuilderFactory storageBuilderFactory = (StorageBuilderFactory)moduleDefineHolder.find("storage").provider().getService(StorageBuilderFactory.class);
        Class<? extends StorageBuilder> builder = storageBuilderFactory.builderOf(streamClass, stream.builder());
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            managementDAO = storageDAO.newManagementDao(builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " none stream record DAO failure.", e);
        }
        ModelCreator modelSetter = (ModelCreator)moduleDefineHolder.find("core").provider().getService(ModelCreator.class);
        Model model = modelSetter.add(streamClass, stream.scopeId(), new Storage(stream.name(), false, DownSampling.None), false);
        ManagementPersistentWorker persistentWorker = new ManagementPersistentWorker(moduleDefineHolder, model, managementDAO);
        this.workers.put(streamClass, persistentWorker);
    }
}

