/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.ConstOne;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="longAvg")
public abstract class LongAvgMetrics
extends Metrics
implements LongValueHolder {
    protected static final String SUMMATION = "summation";
    protected static final String COUNT = "count";
    protected static final String VALUE = "value";
    @Column(columnName="summation", storageOnly=true)
    protected long summation;
    @Column(columnName="count", storageOnly=true)
    protected long count;
    @Column(columnName="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    private long value;

    @Entrance
    public final void combine(@SourceFrom long summation, @ConstOne long count) {
        this.summation += summation;
        this.count += count;
    }

    @Override
    public final boolean combine(Metrics metrics) {
        LongAvgMetrics longAvgMetrics = (LongAvgMetrics)metrics;
        this.combine(longAvgMetrics.summation, longAvgMetrics.count);
        return true;
    }

    @Override
    public final void calculate() {
        this.value = this.summation / this.count;
    }

    @Generated
    public long getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(long summation) {
        this.summation = summation;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }
}

