/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="histogram")
public abstract class HistogramMetrics
extends Metrics {
    public static final String DATASET = "dataset";
    @Column(columnName="dataset", dataType=Column.ValueDataType.HISTOGRAM, storageOnly=true, defaultValue=0)
    private DataTable dataset = new DataTable(30);

    @Entrance
    public final void combine(@SourceFrom int value, @Arg int step, @Arg int maxNumOfSteps) {
        int index;
        if (!this.dataset.hasData()) {
            for (int i = 0; i <= maxNumOfSteps; ++i) {
                String key = String.valueOf(i * step);
                this.dataset.put(key, 0L);
            }
        }
        if ((index = value / step) > maxNumOfSteps) {
            index = maxNumOfSteps;
        }
        String idx = String.valueOf(index * step);
        this.dataset.valueAccumulation(idx, 1L);
    }

    @Override
    public boolean combine(Metrics metrics) {
        HistogramMetrics histogramMetrics = (HistogramMetrics)metrics;
        this.dataset.append(histogramMetrics.dataset);
        return true;
    }

    @Override
    public final void calculate() {
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }
}

