/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.ConfigurationDictionary;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Arg;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;

@MetricsFunction(functionName="apdex")
public abstract class ApdexMetrics
extends Metrics
implements IntValueHolder {
    private static ConfigurationDictionary DICT;
    protected static final String TOTAL_NUM = "total_num";
    protected static final String S_NUM = "s_num";
    protected static final String T_NUM = "t_num";
    protected static final String VALUE = "value";
    @Column(columnName="total_num", storageOnly=true)
    private long totalNum;
    @Column(columnName="s_num", storageOnly=true)
    private long sNum;
    @Column(columnName="t_num", storageOnly=true)
    private long tNum;
    @Column(columnName="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    @ElasticSearch.Column(columnAlias="int_value")
    private int value;

    @Entrance
    public final void combine(@SourceFrom int value, @Arg String name, @Arg boolean status) {
        int t = DICT.lookup(name).intValue();
        int t4 = t * 4;
        ++this.totalNum;
        if (!status || value > t4) {
            return;
        }
        if (value > t) {
            ++this.tNum;
        } else {
            ++this.sNum;
        }
    }

    @Override
    public final boolean combine(Metrics metrics) {
        this.tNum += ((ApdexMetrics)metrics).tNum;
        this.sNum += ((ApdexMetrics)metrics).sNum;
        this.totalNum += ((ApdexMetrics)metrics).totalNum;
        return true;
    }

    @Override
    public void calculate() {
        this.value = (int)((this.sNum * 10000L + this.tNum * 10000L / 2L) / this.totalNum);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Generated
    public static void setDICT(ConfigurationDictionary DICT) {
        ApdexMetrics.DICT = DICT;
    }

    @Generated
    public long getTotalNum() {
        return this.totalNum;
    }

    @Generated
    public void setTotalNum(long totalNum) {
        this.totalNum = totalNum;
    }

    @Generated
    public long getSNum() {
        return this.sNum;
    }

    @Generated
    public void setSNum(long sNum) {
        this.sNum = sNum;
    }

    @Generated
    public long getTNum() {
        return this.tNum;
    }

    @Generated
    public void setTNum(long tNum) {
        this.tNum = tNum;
    }

    @Generated
    public void setValue(int value) {
        this.value = value;
    }
}

