/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.sum;

import com.google.common.base.Strings;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.meter.function.PercentileArgument;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="sumHistogramPercentile")
public abstract class SumHistogramPercentileFunction
extends Meter
implements AcceptableValue<PercentileArgument>,
MultiIntValuesHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SumHistogramPercentileFunction.class);
    private static final String DEFAULT_GROUP = "pD";
    public static final String DATASET = "dataset";
    public static final String RANKS = "ranks";
    public static final String VALUE = "value";
    protected static final String SUMMATION = "summation";
    @Column(columnName="entity_id")
    @BanyanDB.ShardingKey(index=0)
    private String entityId;
    @Column(columnName="value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(columnAlias="datatable_value")
    private DataTable percentileValues = new DataTable(10);
    @Column(columnName="summation", storageOnly=true)
    @ElasticSearch.Column(columnAlias="datatable_summation")
    protected DataTable summation = new DataTable(30);
    @Column(columnName="ranks", storageOnly=true)
    private IntList ranks = new IntList(10);
    private boolean isCalculated = false;

    @Override
    public void accept(MeterEntity entity, PercentileArgument value) {
        if (this.summation.size() > 0 && !value.getBucketedValues().isCompatible(this.summation)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current PercentileFunction[" + this.summation + "]");
        }
        for (int rank : value.getRanks()) {
            if (rank > 0) continue;
            throw new IllegalArgumentException("Illegal rank value " + rank + ", must be positive");
        }
        if (this.ranks.size() > 0) {
            if (this.ranks.size() != value.getRanks().length) {
                throw new IllegalArgumentException("Incompatible ranks size = [" + value.getRanks().length + "] for current PercentileFunction[" + this.ranks.size() + "]");
            }
            for (int rank : value.getRanks()) {
                if (this.ranks.include(rank)) continue;
                throw new IllegalArgumentException("Rank " + rank + " doesn't exist in the previous ranks " + this.ranks);
            }
        } else {
            for (int rank : value.getRanks()) {
                this.ranks.add(rank);
            }
        }
        this.entityId = entity.id();
        String template = "%s";
        if (!Strings.isNullOrEmpty((String)value.getBucketedValues().getGroup())) {
            template = value.getBucketedValues().getGroup() + ":%s";
        }
        long[] values = value.getBucketedValues().getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBucketedValues().getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            String key = String.format(template, bucketName);
            this.summation.valueAccumulation(key, values[i]);
        }
        this.isCalculated = false;
    }

    @Override
    public boolean combine(Metrics metrics) {
        SumHistogramPercentileFunction percentile = (SumHistogramPercentileFunction)metrics;
        if (this.ranks.size() > 0) {
            IntList ranksOfThat = percentile.getRanks();
            if (this.ranks.size() != ranksOfThat.size()) {
                log.warn("Incompatible ranks size = [{}}] for current PercentileFunction[{}]", (Object)ranksOfThat.size(), (Object)this.ranks.size());
                return true;
            }
            if (!this.ranks.equals(ranksOfThat)) {
                log.warn("Rank {} doesn't exist in the previous ranks {}", (Object)ranksOfThat, (Object)this.ranks);
                return true;
            }
        }
        this.summation.append(percentile.summation);
        this.isCalculated = false;
        return true;
    }

    @Override
    public void calculate() {
        if (!this.isCalculated) {
            this.summation.keys().stream().map(key -> {
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    return Tuple.of((Object)key.substring(0, index), (Object)key);
                }
                return Tuple.of((Object)DEFAULT_GROUP, (Object)key);
            }).collect(Collectors.groupingBy(Tuple2::_1, Collectors.mapping(Tuple2::_2, Collector.of(DataTable::new, (dt, key) -> {
                String v;
                if (key.contains(":")) {
                    int index = key.lastIndexOf(":");
                    v = key.substring(index + 1);
                } else {
                    v = key;
                }
                dt.put(v, this.summation.get((String)key));
            }, DataTable::append, new Collector.Characteristics[0])))).forEach((group, subDataset) -> {
                long total = subDataset.sumOfValues();
                int[] roofs = new int[this.ranks.size()];
                for (int i = 0; i < this.ranks.size(); ++i) {
                    roofs[i] = Math.round((float)(total * (long)this.ranks.get(i)) * 1.0f / 100.0f);
                }
                int count = 0;
                List<String> sortedKeys = subDataset.sortedKeys(Comparator.comparingLong(Long::parseLong));
                int loopIndex = 0;
                for (String key : sortedKeys) {
                    int roof;
                    Long value = subDataset.get(key);
                    count = (int)((long)count + value);
                    for (int rankIdx = loopIndex; rankIdx < roofs.length && count >= (roof = roofs[rankIdx]); ++rankIdx) {
                        if (group.equals(DEFAULT_GROUP)) {
                            this.percentileValues.put(String.valueOf(this.ranks.get(rankIdx)), Long.parseLong(key));
                        } else {
                            this.percentileValues.put(String.format("%s:%s", group, this.ranks.get(rankIdx)), Long.parseLong(key));
                        }
                        ++loopIndex;
                    }
                }
            });
        }
    }

    @Override
    public Metrics toHour() {
        SumHistogramPercentileFunction metrics = (SumHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setSummation(this.getSummation());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        SumHistogramPercentileFunction metrics = (SumHistogramPercentileFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setSummation(this.getSummation());
        metrics.setRanks(this.getRanks());
        metrics.setPercentileValues(this.getPercentileValues());
        return metrics;
    }

    @Override
    public int[] getValues() {
        return this.percentileValues.sortedValues(Comparator.comparingInt(Integer::parseInt)).stream().flatMapToInt(l -> IntStream.of(l.intValue())).toArray();
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setSummation(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setRanks(new IntList(remoteData.getDataObjectStrings(1)));
        this.setPercentileValues(new DataTable(remoteData.getDataObjectStrings(2)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.summation.toStorageData());
        remoteBuilder.addDataObjectStrings(this.ranks.toStorageData());
        remoteBuilder.addDataObjectStrings(this.percentileValues.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected String id0() {
        return this.getTimeBucket() + "_" + this.entityId;
    }

    @Override
    public Class<? extends AvgPercentileFunctionBuilder> builder() {
        return AvgPercentileFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SumHistogramPercentileFunction)) {
            return false;
        }
        SumHistogramPercentileFunction function = (SumHistogramPercentileFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getPercentileValues() {
        return this.percentileValues;
    }

    @Generated
    public void setPercentileValues(DataTable percentileValues) {
        this.percentileValues = percentileValues;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public IntList getRanks() {
        return this.ranks;
    }

    @Generated
    public void setRanks(IntList ranks) {
        this.ranks = ranks;
    }

    public static class AvgPercentileFunctionBuilder
    implements StorageBuilder<SumHistogramPercentileFunction> {
        @Override
        public SumHistogramPercentileFunction storage2Entity(Convert2Entity converter) {
            SumHistogramPercentileFunction metrics = new SumHistogramPercentileFunction(){

                @Override
                public AcceptableValue<PercentileArgument> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setSummation(new DataTable((String)converter.get(SumHistogramPercentileFunction.SUMMATION)));
            metrics.setRanks(new IntList((String)converter.get(SumHistogramPercentileFunction.RANKS)));
            metrics.setPercentileValues(new DataTable((String)converter.get(SumHistogramPercentileFunction.VALUE)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(SumHistogramPercentileFunction storageData, Convert2Storage converter) {
            converter.accept(SumHistogramPercentileFunction.SUMMATION, storageData.getSummation());
            converter.accept(SumHistogramPercentileFunction.RANKS, storageData.getRanks());
            converter.accept(SumHistogramPercentileFunction.VALUE, storageData.getPercentileValues());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

